"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetupModeTooltip = SetupModeTooltip;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _formatting = require("./formatting");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/setup_mode/tooltip.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SetupModeTooltip({
  setupModeData,
  badgeClickLink,
  productName
}) {
  if (!setupModeData) {
    return null;
  }
  const {
    totalUniqueInstanceCount,
    totalUniqueFullyMigratedCount,
    totalUniquePartiallyMigratedCount
  } = setupModeData;
  const allMonitoredByMetricbeat = totalUniqueInstanceCount > 0 && (totalUniqueFullyMigratedCount === totalUniqueInstanceCount || totalUniquePartiallyMigratedCount === totalUniqueInstanceCount);
  const internalCollectionOn = totalUniquePartiallyMigratedCount > 0;
  const mightExist = (0, _lodash.get)(setupModeData, 'detected.mightExist') || (0, _lodash.get)(setupModeData, 'detected.doesExist');
  let tooltip = null;
  if (totalUniqueInstanceCount === 0) {
    if (mightExist) {
      const detectedText = _i18n.i18n.translate('xpack.monitoring.setupMode.tooltip.detected', {
        defaultMessage: 'No monitoring'
      });
      tooltip = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: _i18n.i18n.translate('xpack.monitoring.setupMode.tooltip.mightExist', {
          defaultMessage: `We detected usage of this product. Click to start monitoring.`
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning",
        iconType: "flag",
        href: badgeClickLink,
        onClickAriaLabel: detectedText,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 11
        }
      }, detectedText));
    } else {
      const noMonitoringText = _i18n.i18n.translate('xpack.monitoring.setupMode.tooltip.noUsage', {
        defaultMessage: 'No usage'
      });
      tooltip = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: _i18n.i18n.translate('xpack.monitoring.setupMode.tooltip.noUsageDetected', {
          defaultMessage: `We did not detect any usage. Click to view {identifier}.`,
          values: {
            identifier: (0, _formatting.getIdentifier)(productName, true)
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        iconType: "flag",
        href: badgeClickLink,
        onClickAriaLabel: noMonitoringText,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 11
        }
      }, noMonitoringText));
    }
  } else if (!allMonitoredByMetricbeat) {
    const internalCollection = _i18n.i18n.translate('xpack.monitoring.euiTable.isInternalCollectorLabel', {
      defaultMessage: 'Self monitoring'
    });
    tooltip = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.monitoring.setupMode.tooltip.oneInternal', {
        defaultMessage: `At least one {identifier} isn’t monitored using Metricbeat. Click to view status.`,
        values: {
          identifier: (0, _formatting.getIdentifier)(productName)
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "danger",
      iconType: "flag",
      href: badgeClickLink,
      onClickAriaLabel: internalCollection,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    }, internalCollection));
  } else if (internalCollectionOn) {
    const internalAndMB = _i18n.i18n.translate('xpack.monitoring.euiTable.isPartiallyMigratedLabel', {
      defaultMessage: 'Self monitoring is on'
    });
    tooltip = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.monitoring.setupMode.tooltip.disableInternal', {
        defaultMessage: `Metricbeat is monitoring all {identifierPlural}. Click to view {identifierPlural} and disable self monitoring.`,
        values: {
          identifierPlural: (0, _formatting.getIdentifier)(productName, true)
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning",
      iconType: "flag",
      href: badgeClickLink,
      onClickAriaLabel: internalAndMB,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 9
      }
    }, internalAndMB));
  } else {
    const metricbeatCollection = _i18n.i18n.translate('xpack.monitoring.euiTable.isFullyMigratedLabel', {
      defaultMessage: 'Metricbeat monitoring'
    });
    tooltip = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.monitoring.setupMode.tooltip.allSet', {
        defaultMessage: `Metricbeat is monitoring all {identifierPlural}.`,
        values: {
          identifierPlural: (0, _formatting.getIdentifier)(productName, true)
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "success",
      iconType: "flag",
      href: badgeClickLink,
      onClickAriaLabel: metricbeatCollection,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 9
      }
    }, metricbeatCollection));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "monitoringSetupModeMetricbeatMigrationTooltip",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 5
    }
  }, tooltip);
}