"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KueryBar = void 0;
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _autocomplete_field = require("./autocomplete_field");
var _with_kuery_autocompletion = require("./with_kuery_autocompletion");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/kuery_bar/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function validateQuery(query) {
  try {
    (0, _esQuery.fromKueryExpression)(query);
  } catch (err) {
    return false;
  }
  return true;
}
const KueryBar = ({
  derivedIndexPattern,
  onSubmit,
  onChange,
  value,
  placeholder,
  curryLoadSuggestions = defaultCurryLoadSuggestions
}) => {
  const [draftQuery, setDraftQuery] = (0, _react.useState)(value || '');
  const [isValid, setValidation] = (0, _react.useState)(true);

  // This ensures that if value changes out side this component it will update.
  (0, _react.useEffect)(() => {
    if (value) {
      setDraftQuery(value);
    }
  }, [value]);
  const handleChange = query => {
    setValidation(validateQuery(query));
    setDraftQuery(query);
    if (onChange) {
      onChange(query);
    }
  };
  const defaultPlaceholder = _i18n.i18n.translate('xpack.monitoring.alerts.kqlSearchFieldPlaceholder', {
    defaultMessage: 'Search for monitoring data'
  });
  return /*#__PURE__*/_react.default.createElement(_with_kuery_autocompletion.WithKueryAutocompletion, {
    indexPattern: derivedIndexPattern,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, ({
    isLoadingSuggestions,
    loadSuggestions,
    suggestions
  }) => /*#__PURE__*/_react.default.createElement(_autocomplete_field.AutocompleteField, {
    "aria-label": placeholder,
    isLoadingSuggestions: isLoadingSuggestions,
    isValid: isValid,
    loadSuggestions: curryLoadSuggestions(loadSuggestions),
    onChange: handleChange,
    onSubmit: onSubmit,
    placeholder: placeholder || defaultPlaceholder,
    suggestions: suggestions,
    value: draftQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }));
};
exports.KueryBar = KueryBar;
const defaultCurryLoadSuggestions = loadSuggestions => (...args) => loadSuggestions(...args);