"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchIndices = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _status = require("../../../alerts/status");
var _cluster_status = require("../cluster_status");
var _status_icon = require("../status_icon");
var _table = require("../../table");
var _formatting = require("../../../../common/formatting");
var _format_number = require("../../../lib/format_number");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/elasticsearch/indices/indices.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const statusStyle = (0, _react2.css)`
  display: flex;
  align-items: center;
`;
const getColumns = alerts => {
  return [{
    name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.nameTitle', {
      defaultMessage: 'Name'
    }),
    field: 'name',
    width: '350px',
    sortable: true,
    render: value => /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: (0, _get_safe_for_external_link.getSafeForExternalLink)(`#/elasticsearch/indices/${value}`),
      "data-test-subj": `indexLink-${value}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 11
      }
    }, value))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.alertsColumnTitle', {
      defaultMessage: 'Alerts'
    }),
    field: 'alerts',
    sortable: true,
    render: (_field, index) => {
      return /*#__PURE__*/_react.default.createElement(_status.AlertsStatus, {
        showBadge: true,
        alerts: alerts,
        stateFilter: state => state.meta.shardIndex === index.name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 11
        }
      });
    }
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.statusTitle', {
      defaultMessage: 'Status'
    }),
    field: 'status',
    sortable: true,
    render: value => /*#__PURE__*/_react.default.createElement("div", {
      css: statusStyle,
      title: `Index status: ${value}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_status_icon.ElasticsearchStatusIcon, {
      status: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    }), "\xA0", (0, _lodash.capitalize)(value))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.documentCountTitle', {
      defaultMessage: 'Document Count'
    }),
    field: 'doc_count',
    sortable: true,
    render: value => /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "documentCount",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 9
      }
    }, (0, _format_number.formatMetric)(value, _formatting.LARGE_ABBREVIATED))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.dataTitle', {
      defaultMessage: 'Data'
    }),
    field: 'data_size',
    sortable: true,
    render: value => /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "dataSize",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 26
      }
    }, (0, _format_number.formatMetric)(value, _formatting.LARGE_BYTES))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.indexRateTitle', {
      defaultMessage: 'Index Rate'
    }),
    field: 'index_rate',
    sortable: true,
    render: value => /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "indexRate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 9
      }
    }, (0, _format_number.formatMetric)(value, _formatting.LARGE_FLOAT, '/s'))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.searchRateTitle', {
      defaultMessage: 'Search Rate'
    }),
    field: 'search_rate',
    sortable: true,
    render: value => /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "searchRate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 9
      }
    }, (0, _format_number.formatMetric)(value, _formatting.LARGE_FLOAT, '/s'))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.unassignedShardsTitle', {
      defaultMessage: 'Unassigned Shards'
    }),
    field: 'unassigned_shards',
    sortable: true,
    render: value => /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "unassignedShards",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 26
      }
    }, (0, _format_number.formatMetric)(value, '0'))
  }];
};
const getNoDataMessage = () => {
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.indices.noIndicesMatchYourSelectionDescription",
    defaultMessage: "There are no indices that match your selections. Try changing the time range selection.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.indices.howToShowSystemIndicesDescription",
    defaultMessage: "If you are looking for system indices (e.g., .kibana), try checking \u2018Filter for system indices\u2019.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  })));
};
const ElasticsearchIndices = ({
  clusterStatus,
  indices,
  sorting,
  pagination,
  onTableChange,
  toggleShowSystemIndices,
  showSystemIndices,
  alerts
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.indices.heading",
    defaultMessage: "Elasticsearch indices",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_cluster_status.ClusterStatus, {
    stats: clusterStatus,
    alerts: alerts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.elasticsearch.indices.systemIndicesLabel",
      defaultMessage: "Filter for system indices",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 15
      }
    }),
    checked: showSystemIndices,
    onChange: e => toggleShowSystemIndices(e.target.checked),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_table.EuiMonitoringTable, {
    "data-test-subj": "elasticsearchIndicesTable",
    rows: indices,
    columns: getColumns(alerts),
    sorting: sorting,
    pagination: pagination,
    message: getNoDataMessage(),
    search: {
      box: {
        incremental: true,
        placeholder: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.monitoringTablePlaceholder', {
          defaultMessage: 'Filter Indices…'
        })
      }
    },
    onTableChange: onTableChange,
    executeQueryOptions: {
      defaultFields: ['name']
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  }))));
};
exports.ElasticsearchIndices = ElasticsearchIndices;