"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClusterStatus = ClusterStatus;
var _react = _interopRequireDefault(require("react"));
var _summary_status = require("../../summary_status");
var _status_icon = require("../status_icon");
var _format_number = require("../../../lib/format_number");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/elasticsearch/cluster_status/index.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ClusterStatus({
  stats,
  alerts
}) {
  const {
    dataSize,
    nodesCount,
    indicesCount,
    memUsed,
    memMax,
    totalShards,
    unassignedShards,
    documentCount,
    status
  } = stats;
  const metrics = [{
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.clusterStatus.nodesLabel', {
      defaultMessage: 'Nodes'
    }),
    value: nodesCount,
    'data-test-subj': 'nodesCount'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.clusterStatus.indicesLabel', {
      defaultMessage: 'Indices'
    }),
    value: indicesCount,
    'data-test-subj': 'indicesCount'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.clusterStatus.memoryLabel', {
      defaultMessage: 'JVM Heap'
    }),
    value: (0, _format_number.formatMetric)(memUsed, 'byte') + ' / ' + (0, _format_number.formatMetric)(memMax, 'byte'),
    'data-test-subj': 'memory'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.clusterStatus.totalShardsLabel', {
      defaultMessage: 'Total shards'
    }),
    value: totalShards,
    'data-test-subj': 'totalShards'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.clusterStatus.unassignedShardsLabel', {
      defaultMessage: 'Unassigned shards'
    }),
    value: unassignedShards,
    'data-test-subj': 'unassignedShards'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.clusterStatus.documentsLabel', {
      defaultMessage: 'Documents'
    }),
    value: (0, _format_number.formatMetric)(documentCount, 'int_commas'),
    'data-test-subj': 'documentCount'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.clusterStatus.dataLabel', {
      defaultMessage: 'Data'
    }),
    value: (0, _format_number.formatMetric)(dataSize, 'byte'),
    'data-test-subj': 'dataSize'
  }];
  const IconComponent = ({
    status
  }) => /*#__PURE__*/_react.default.createElement(_status_icon.ElasticsearchStatusIcon, {
    status: status,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 41
    }
  });
  return /*#__PURE__*/_react.default.createElement(_summary_status.SummaryStatus, {
    metrics: metrics,
    status: status,
    alerts: alerts,
    IconComponent: IconComponent,
    "data-test-subj": "elasticsearchClusterStatus",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  });
}