"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Status = Status;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _summary_status = require("../../summary_status");
var _format_number = require("../../../lib/format_number");
var _i18n = require("@kbn/i18n");
var _status = require("../../../alerts/status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/elasticsearch/ccr_shard/status.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function Status({
  stat,
  formattedLeader,
  oldestStat,
  alerts = {}
}) {
  const followerIndex = stat.follower_index || (0, _lodash.get)(stat, 'follower.index');
  const shardId = typeof stat.shard_id === 'number' ? stat.shard_id : (0, _lodash.get)(stat, 'follower.shard.number');
  const operationsReceived = stat.operations_written || (0, _lodash.get)(stat, 'follower.operations_written');
  const failedFetches = stat.failed_read_requests || (0, _lodash.get)(stat, 'requests.failed.read.count');
  const oldestOperationsReceived = oldestStat.operations_written || (0, _lodash.get)(oldestStat, 'follower.operations_written');
  const oldestFailedFetches = oldestStat.failed_read_requests || (0, _lodash.get)(oldestStat, 'requests.failed.read.count');
  const metrics = [{
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccrShard.status.alerts', {
      defaultMessage: 'Alerts'
    }),
    value: /*#__PURE__*/_react.default.createElement(_status.AlertsStatus, {
      alerts: alerts,
      showOnlyCount: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 14
      }
    })
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccrShard.status.followerIndexLabel', {
      defaultMessage: 'Follower Index'
    }),
    value: followerIndex,
    'data-test-subj': 'followerIndex'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccrShard.status.shardIdLabel', {
      defaultMessage: 'Shard Id'
    }),
    value: shardId,
    'data-test-subj': 'shardId'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccrShard.status.leaderIndexLabel', {
      defaultMessage: 'Leader Index'
    }),
    value: formattedLeader,
    'data-test-subj': 'leaderIndex'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccrShard.status.opsSyncedLabel', {
      defaultMessage: 'Ops Synced'
    }),
    value: (0, _format_number.formatMetric)(operationsReceived - oldestOperationsReceived, 'int_commas'),
    'data-test-subj': 'operationsReceived'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccrShard.status.failedFetchesLabel', {
      defaultMessage: 'Failed Fetches'
    }),
    value: (0, _format_number.formatMetric)(failedFetches - oldestFailedFetches, 'int_commas'),
    'data-test-subj': 'failedFetches'
  }];
  return /*#__PURE__*/_react.default.createElement(_summary_status.SummaryStatus, {
    metrics: metrics,
    "data-test-subj": "ccrDetailStatus",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 10
    }
  });
}