"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createThreadPoolRejectionsAlertType = createThreadPoolRejectionsAlertType;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../common/constants");
var _lazy_expression = require("../components/param_details_form/lazy_expression");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/alerts/thread_pool_rejections_alert/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function createThreadPoolRejectionsAlertType(alertId, threadPoolAlertDetails, config) {
  return {
    id: alertId,
    description: threadPoolAlertDetails.description,
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.monitoring.alertsKibanaThreadpoolRejections}`;
    },
    ruleParamsExpression: props => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_lazy_expression.LazyExpression, (0, _extends2.default)({}, props, {
      config: config,
      paramDetails: threadPoolAlertDetails.paramDetails,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 9
      }
    }))),
    validate: inputValues => {
      const errors = {};
      const value = inputValues.threshold;
      if (value < 0) {
        const errStr = _i18n.i18n.translate('xpack.monitoring.alerts.validation.lessThanZero', {
          defaultMessage: 'This value can not be less than zero'
        });
        errors.threshold = [errStr];
      }
      if (!inputValues.duration) {
        const errStr = _i18n.i18n.translate('xpack.monitoring.alerts.validation.duration', {
          defaultMessage: 'A valid duration is required.'
        });
        errors.duration = [errStr];
      }
      return {
        errors
      };
    },
    defaultActionMessage: '{{context.internalFullMessage}}',
    requiresAppContext: _constants.RULE_REQUIRES_APP_CONTEXT
  };
}