"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCCRReadExceptionsAlertType = createCCRReadExceptionsAlertType;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _validate_duration = require("../../../common/validate_duration");
var _constants = require("../../../common/constants");
var _lazy_expression = require("../components/param_details_form/lazy_expression");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/alerts/ccr_read_exceptions_alert/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function createCCRReadExceptionsAlertType(config) {
  return {
    id: _constants.RULE_CCR_READ_EXCEPTIONS,
    description: _constants.RULE_DETAILS[_constants.RULE_CCR_READ_EXCEPTIONS].description,
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.monitoring.alertsKibanaCCRReadExceptions}`;
    },
    ruleParamsExpression: props => /*#__PURE__*/_react.default.createElement(_lazy_expression.LazyExpression, (0, _extends2.default)({}, props, {
      config: config,
      paramDetails: _constants.RULE_DETAILS[_constants.RULE_CCR_READ_EXCEPTIONS].paramDetails,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 7
      }
    })),
    validate: _validate_duration.validateDuration,
    defaultActionMessage: '{{context.internalFullMessage}}',
    requiresAppContext: _constants.RULE_REQUIRES_APP_CONTEXT
  };
}