"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Modal = Modal;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _message_call_out = require("../../../components/message_call_out");
var _kibana = require("../../../contexts/kibana");
var _check_ml_nodes = require("../../../ml_nodes_check/check_ml_nodes");
var _forecasts_list = require("./forecasts_list");
var _run_controls = require("./run_controls");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/timeseriesexplorer/components/forecasting_modal/modal.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Renders the modal dialog which allows the user to run and view time series forecasts.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Modal(props) {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [mlNodesAvailable, setMlNodesAvailable] = (0, _react.useState)(false);
  const {
    services: {
      mlServices: {
        mlApi
      }
    }
  } = (0, _kibana.useMlKibana)();
  (0, _react.useEffect)(function prepMlNodeCheck() {
    (0, _check_ml_nodes.getMlNodeCount)(mlApi).then(({
      count,
      lazyNodeCount
    }) => {
      setMlNodesAvailable(count !== 0 || lazyNodeCount !== 0);
    }).catch(console.error);
  }, [mlApi]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: props.close,
    maxWidth: 860,
    "data-test-subj": "mlModalForecast",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.timeSeriesExplorer.forecastingModal.forecastingTitle",
    defaultMessage: "Forecasting",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, props.messages.map((message, i) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: i,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_message_call_out.MessageCallOut, (0, _extends2.default)({}, message, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 13
    }
  }))), props.forecasts.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_forecasts_list.ForecastsList, {
    forecasts: props.forecasts,
    viewForecast: props.viewForecast,
    selectedForecastId: props.selectedForecastId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_run_controls.RunControls, (0, _extends2.default)({}, props, {
    mlNodesAvailable: mlNodesAvailable,
    jobState: props.jobState,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: props.close,
    size: "s",
    "data-test-subj": "mlModalForecastButtonClose",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.timeSeriesExplorer.forecastingModal.closeButtonLabel",
    defaultMessage: "Close",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }))));
}
Modal.propType = {
  job: _propTypes.default.object,
  forecasts: _propTypes.default.array,
  close: _propTypes.default.func.isRequired,
  viewForecast: _propTypes.default.func.isRequired,
  runForecast: _propTypes.default.func.isRequired,
  newForecastDuration: _propTypes.default.string,
  isNewForecastDurationValid: _propTypes.default.bool,
  newForecastDurationErrors: _propTypes.default.array,
  onNewForecastDurationChange: _propTypes.default.func.isRequired,
  isForecastRequested: _propTypes.default.bool,
  forecastProgress: _propTypes.default.number,
  jobOpeningState: _propTypes.default.number,
  jobClosingState: _propTypes.default.number,
  messages: _propTypes.default.array,
  selectedForecastId: _propTypes.default.string
};