"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jobListRouteFactory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _jobs_list = require("../../../../common/constants/jobs_list");
var _router = require("../router");
var _use_resolver = require("../use_resolver");
var _breadcrumbs = require("../breadcrumbs");
var _annotations_service = require("../../services/annotations_service");
var _ml_annotation_updates_context = require("../../contexts/ml/ml_annotation_updates_context");
var _resolvers = require("../resolvers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/routing/routes/jobs_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JobsPage = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('../../jobs/jobs_list')))).JobsPage
}));
const jobListRouteFactory = navigateToApp => ({
  id: 'anomaly_detection',
  title: _i18n.i18n.translate('xpack.ml.anomalyDetection.jobs.docTitle', {
    defaultMessage: 'Anomaly Detection Jobs'
  }),
  path: '/',
  render: () => /*#__PURE__*/_react.default.createElement(PageWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 17
    }
  }),
  breadcrumbs: [(0, _breadcrumbs.getStackManagementBreadcrumb)(navigateToApp), {
    text: _i18n.i18n.translate('xpack.ml.anomalyDetection.jobsManagementLabel', {
      defaultMessage: 'Anomaly Detection Jobs'
    })
  }],
  'data-test-subj': 'mlPageJobManagement',
  enableDatePicker: false
});
exports.jobListRouteFactory = jobListRouteFactory;
const PageWrapper = () => {
  var _mlTimefilterRefresh$, _refresh$value, _refresh$pause;
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetJobs'], {
    ...(0, _resolvers.basicResolvers)(),
    initSavedObjects: _resolvers.initSavedObjects
  });
  const timefilter = (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: false,
    autoRefreshSelector: true
  });
  const refresh = (0, _mlDatePicker.useRefreshIntervalUpdates)();
  const mlTimefilterRefresh = (0, _useObservable.default)(_mlDatePicker.mlTimefilterRefresh$);
  const lastRefresh = (_mlTimefilterRefresh$ = mlTimefilterRefresh === null || mlTimefilterRefresh === void 0 ? void 0 : mlTimefilterRefresh.lastRefresh) !== null && _mlTimefilterRefresh$ !== void 0 ? _mlTimefilterRefresh$ : 0;
  const refreshValue = (_refresh$value = refresh.value) !== null && _refresh$value !== void 0 ? _refresh$value : 0;
  const refreshPause = (_refresh$pause = refresh.pause) !== null && _refresh$pause !== void 0 ? _refresh$pause : true;
  const refreshList = (0, _react.useCallback)(() => {
    _mlDatePicker.mlTimefilterRefresh$.next({
      lastRefresh: Date.now()
    });
  }, []);
  (0, _react.useEffect)(() => {
    const refreshInterval = refreshValue === 0 || refreshPause === true ? {
      pause: false,
      value: _jobs_list.DEFAULT_REFRESH_INTERVAL_MS
    } : {
      pause: refreshPause,
      value: refreshValue
    };
    timefilter.setRefreshInterval(refreshInterval);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const annotationUpdatesService = (0, _react.useMemo)(() => new _annotations_service.AnnotationUpdatesService(), []);
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_ml_annotation_updates_context.MlAnnotationUpdatesContext.Provider, {
    value: annotationUpdatesService,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(JobsPage, {
    lastRefresh: lastRefresh,
    refreshList: refreshList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  })));
};