"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandedRow = void 0;
exports.useListItemsFormatter = useListItemsFormatter;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/field-formats-plugin/common");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _inference_api_tab = require("./inference_api_tab");
var _pipelines = require("./pipelines");
var _allocated_models = require("../memory_usage/nodes_overview/allocated_models");
var _use_field_formatter = require("../contexts/kibana/use_field_formatter");
var _ml = require("../contexts/ml");
var _trained_models = require("../../../common/types/trained_models");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/model_management/expanded_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JobMap = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('../data_frame_analytics/pages/job_map')))).JobMap
}));
const useBadgeFormatter = () => {
  const xs = (0, _eui.useEuiPaddingSize)('xs');
  function badgeFormatter(items) {
    if (items.length === 0) return;
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 7
      }
    }, items.map(item => /*#__PURE__*/_react.default.createElement("span", {
      css: {
        marginRight: xs
      },
      key: item,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      css: {
        marginRight: xs
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 13
      }
    }, item))));
  }
  return {
    badgeFormatter
  };
};
function useListItemsFormatter() {
  const bytesFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.BYTES);
  const dateFormatter = (0, _use_field_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.DATE);
  const {
    badgeFormatter
  } = useBadgeFormatter();
  const formatterDictionary = (0, _react.useMemo)(() => ({
    tags: badgeFormatter,
    roles: badgeFormatter,
    create_time: dateFormatter,
    timestamp: dateFormatter,
    model_size_bytes: bytesFormatter,
    required_native_memory_bytes: bytesFormatter
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  return (0, _react.useCallback)(items => {
    return Object.entries(items).filter(([, value]) => (0, _mlIsDefined.isDefined)(value)).map(([title, value]) => {
      if (title in formatterDictionary) {
        return {
          title,
          description: formatterDictionary[title](value)
        };
      }
      return {
        title,
        description: typeof value === 'object' ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
          language: "json",
          fontSize: "s",
          paddingSize: "s",
          overflowHeight: 300,
          isCopyable: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 106,
            columnNumber: 17
          }
        }, JSON.stringify(value, null, 2)) : value.toString()
      };
    });
  }, [formatterDictionary]);
}
const ExpandedRow = ({
  item
}) => {
  const formatToListItems = useListItemsFormatter();
  const {
    showLicenseInfo,
    showNodeInfo
  } = (0, _ml.useEnabledFeatures)();
  const {
    inference_config: inferenceConfig,
    stats,
    metadata,
    tags,
    version,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    estimated_operations,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    estimated_heap_memory_usage_bytes,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    default_field_map,
    // eslint-disable-next-line @typescript-eslint/naming-convention
    license_level,
    pipelines,
    description
  } = item;
  const inferenceStats = (0, _react.useMemo)(() => {
    if (!(0, _mlIsPopulatedObject.isPopulatedObject)(stats.inference_stats) || item.model_type === _mlTrainedModelsUtils.TRAINED_MODEL_TYPE.PYTORCH) return;
    return stats.inference_stats;
  }, [stats.inference_stats, item.model_type]);
  const {
    analytics_config: analyticsConfig,
    ...restMetaData
  } = metadata !== null && metadata !== void 0 ? metadata : {};
  const details = (0, _react.useMemo)(() => {
    return {
      description,
      tags,
      version,
      estimated_operations,
      estimated_heap_memory_usage_bytes,
      default_field_map,
      ...(showLicenseInfo ? {
        license_level
      } : {})
    };
  }, [description, tags, version, estimated_operations, estimated_heap_memory_usage_bytes, default_field_map, showLicenseInfo, license_level]);
  const hideColumns = (0, _react.useMemo)(() => {
    return showNodeInfo ? ['model_id'] : ['model_id', 'node_name'];
  }, [showNodeInfo]);
  const deploymentStatItems = (0, _react.useMemo)(() => {
    if (!(0, _trained_models.isNLPModelItem)(item)) return [];
    const deploymentStats = stats.deployment_stats;
    const modelSizeStats = stats.model_size_stats;
    if (!deploymentStats || !modelSizeStats) return [];
    return deploymentStats.flatMap(perDeploymentStat => {
      // A deployment can be in a starting state and not allocated to any node yet.
      if (perDeploymentStat.nodes.length < 1) {
        return [{
          key: `${perDeploymentStat.deployment_id}_no_node`,
          ...perDeploymentStat,
          ...modelSizeStats,
          node: {
            name: '-',
            average_inference_time_ms: 0,
            inference_count: 0,
            routing_state: {
              routing_state: perDeploymentStat.state,
              reason: perDeploymentStat.reason
            },
            last_access: 0,
            number_of_pending_requests: 0,
            start_time: 0,
            throughput_last_minute: 0,
            number_of_allocations: 0,
            threads_per_allocation: 0,
            error_count: 0
          }
        }];
      }
      return perDeploymentStat.nodes.map(n => {
        var _Object$values$;
        const nodeName = (_Object$values$ = Object.values(n.node || {})[0]) === null || _Object$values$ === void 0 ? void 0 : _Object$values$.name;
        return {
          key: `${perDeploymentStat.deployment_id}_${nodeName}`,
          ...perDeploymentStat,
          ...modelSizeStats,
          node: {
            ...(0, _lodash.pick)(n, ['average_inference_time_ms', 'inference_count', 'routing_state', 'last_access', 'number_of_pending_requests', 'start_time', 'throughput_last_minute', 'number_of_allocations', 'threads_per_allocation', 'error_count']),
            name: nodeName
          }
        };
      });
    });
  }, [stats, item]);
  const tabs = (0, _react.useMemo)(() => {
    return [{
      id: 'details',
      'data-test-subj': 'mlTrainedModelDetails',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.detailsTabLabel",
        defaultMessage: "Details",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 249,
          columnNumber: 11
        }
      }),
      content: /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": 'mlTrainedModelDetailsContent',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 255,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 's',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 256,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
        columns: 2,
        gutterSize: 'm',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 257,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 258,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 259,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: 'xs',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 260,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("h5", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 261,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.detailsTitle",
        defaultMessage: "Details",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 262,
          columnNumber: 23
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 'm',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 268,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
        compressed: true,
        type: "column",
        listItems: formatToListItems(details),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 269,
          columnNumber: 19
        }
      }))), (0, _mlIsPopulatedObject.isPopulatedObject)(restMetaData) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 277,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 278,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: 'xs',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 279,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement("h5", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 280,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.metadataTitle",
        defaultMessage: "Metadata",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 281,
          columnNumber: 25
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 'm',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 287,
          columnNumber: 21
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
        compressed: true,
        type: "column",
        listItems: formatToListItems(restMetaData),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 288,
          columnNumber: 21
        }
      }))) : null))
    }, ...(inferenceConfig ? [{
      id: 'config',
      'data-test-subj': 'mlTrainedModelInferenceConfig',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.configTabLabel",
        defaultMessage: "Config",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 306,
          columnNumber: 17
        }
      }),
      content: /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": 'mlTrainedModelInferenceConfigContent',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 312,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 's',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 313,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
        columns: 2,
        gutterSize: 'm',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 314,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 315,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 316,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: 'xs',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 317,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement("h5", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 318,
          columnNumber: 27
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.inferenceConfigTitle",
        defaultMessage: "Inference configuration",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 319,
          columnNumber: 29
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 'm',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 325,
          columnNumber: 25
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
        compressed: true,
        type: "column",
        listItems: formatToListItems(Object.values(inferenceConfig)[0]),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 326,
          columnNumber: 25
        }
      }))), analyticsConfig && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 334,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 335,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: 'xs',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 336,
          columnNumber: 27
        }
      }, /*#__PURE__*/_react.default.createElement("h5", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 337,
          columnNumber: 29
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.analyticsConfigTitle",
        defaultMessage: "Analytics configuration",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 338,
          columnNumber: 31
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 'm',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 344,
          columnNumber: 27
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
        compressed: true,
        type: "column",
        listItems: formatToListItems(analyticsConfig),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 345,
          columnNumber: 27
        }
      })))))
    }] : []), ...((0, _mlIsPopulatedObject.isPopulatedObject)((0, _lodash.omit)(stats, ['pipeline_count', 'ingest'])) ? [{
      id: 'stats',
      'data-test-subj': 'mlTrainedModelStats',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.statsTabLabel",
        defaultMessage: "Stats",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 365,
          columnNumber: 17
        }
      }),
      content: /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": 'mlTrainedModelStatsContent',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 371,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 's',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 372,
          columnNumber: 19
        }
      }), !!(deploymentStatItems !== null && deploymentStatItems !== void 0 && deploymentStatItems.length) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 376,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: 'xs',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 377,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement("h5", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 378,
          columnNumber: 27
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.deploymentStatsTitle",
        defaultMessage: "Deployment stats",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 379,
          columnNumber: 29
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 'm',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 385,
          columnNumber: 25
        }
      }), /*#__PURE__*/_react.default.createElement(_allocated_models.AllocatedModels, {
        models: deploymentStatItems,
        hideColumns: hideColumns,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 386,
          columnNumber: 25
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 's',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 388,
          columnNumber: 23
        }
      })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
        columns: 2,
        gutterSize: 'm',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 392,
          columnNumber: 19
        }
      }, inferenceStats ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 394,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 395,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: 'xs',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 396,
          columnNumber: 27
        }
      }, /*#__PURE__*/_react.default.createElement("h5", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 397,
          columnNumber: 29
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.inferenceStatsTitle",
        defaultMessage: "Inference stats",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 398,
          columnNumber: 31
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 'm',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 404,
          columnNumber: 27
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
        compressed: true,
        type: "column",
        listItems: formatToListItems(inferenceStats),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 405,
          columnNumber: 27
        }
      }))) : null, (0, _mlIsPopulatedObject.isPopulatedObject)(stats.model_size_stats) && !(0, _mlIsPopulatedObject.isPopulatedObject)(inferenceStats) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 415,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 416,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: 'xs',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 417,
          columnNumber: 27
        }
      }, /*#__PURE__*/_react.default.createElement("h5", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 418,
          columnNumber: 29
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.modelSizeStatsTitle",
        defaultMessage: "Model size stats",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 419,
          columnNumber: 31
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 'm',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 425,
          columnNumber: 27
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
        compressed: true,
        type: "column",
        listItems: formatToListItems(stats.model_size_stats),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 426,
          columnNumber: 27
        }
      }))) : null))
    }] : []), ...((0, _mlIsPopulatedObject.isPopulatedObject)(pipelines) && Object.keys(pipelines).length > 0 || stats.ingest ? [{
      id: 'pipelines',
      'data-test-subj': 'mlTrainedModelPipelines',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: 'center',
        gutterSize: 'xs',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 446,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 447,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.pipelinesTabLabel",
        defaultMessage: "Pipelines",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 448,
          columnNumber: 21
        }
      })), (0, _mlIsPopulatedObject.isPopulatedObject)(pipelines) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 454,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 455,
          columnNumber: 23
        }
      }, Object.keys(pipelines).length)) : null),
      content: /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": 'mlTrainedModelPipelinesContent',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 461,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 's',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 462,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_pipelines.ModelPipelines, {
        pipelines: pipelines,
        ingestStats: stats.ingest,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 463,
          columnNumber: 19
        }
      }))
    }] : []), ...(Array.isArray(item.inference_apis) && item.inference_apis.length > 0 ? [{
      id: 'inferenceApi',
      'data-test-subj': 'inferenceAPIs',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: 'center',
        gutterSize: 'xs',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 475,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 476,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.inferenceAPIsTabLabel",
        defaultMessage: "Inference services",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 477,
          columnNumber: 21
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 482,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 483,
          columnNumber: 21
        }
      }, item.inference_apis.length))),
      content: /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": 'mlTrainedModelInferenceAPIContent',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 488,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 's',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 489,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_inference_api_tab.InferenceApi, {
        inferenceApis: item.inference_apis,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 490,
          columnNumber: 19
        }
      }))
    }] : []), {
      id: 'models_map',
      'data-test-subj': 'mlTrainedModelMap',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.trainedModels.modelsList.expandedRow.modelsMapLabel",
        defaultMessage: "Models map",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 500,
          columnNumber: 11
        }
      }),
      content: /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": 'mlTrainedModelMapContent',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 506,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 's',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 507,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        css: {
          height: 300
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 508,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(JobMap, {
        analyticsId: undefined,
        modelId: item.model_id,
        forceRefresh: false,
        defaultHeight: 200,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 509,
          columnNumber: 15
        }
      })))
    }];
  }, [analyticsConfig, deploymentStatItems, details, formatToListItems, inferenceConfig, inferenceStats, pipelines, restMetaData, stats, item.model_id, item.inference_apis, hideColumns]);
  const initialSelectedTab = (0, _trained_models.isNLPModelItem)(item) && item.state === _mlTrainedModelsUtils.MODEL_STATE.STARTED ? tabs.find(t => t.id === 'stats') : tabs[0];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    size: "s",
    css: {
      width: '100%'
    },
    tabs: tabs,
    initialSelectedTab: initialSelectedTab,
    autoFocus: "selected",
    "data-test-subj": 'mlTrainedModelRowDetails',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 541,
      columnNumber: 5
    }
  });
};
exports.ExpandedRow = ExpandedRow;