"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SplitFieldSelect = void 0;
var _react = _interopRequireDefault(require("react"));
var _mlFieldStatsFlyout = require("@kbn/ml-field-stats-flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/split_field_select/split_field_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SplitFieldSelect = ({
  fields,
  changeHandler,
  selectedField,
  isClearable,
  testSubject,
  placeholder,
  titleId
}) => {
  const {
    optionCss
  } = (0, _mlFieldStatsFlyout.useFieldStatsTrigger)();
  const options = fields.map(f => ({
    label: f.name,
    field: f,
    css: optionCss
  }));
  const selection = [];
  if (selectedField !== null) {
    selection.push({
      label: selectedField.name,
      field: selectedField
    });
  }
  function onChange(selectedOptions) {
    const option = selectedOptions[0];
    if (typeof (option === null || option === void 0 ? void 0 : option.field) !== 'undefined') {
      changeHandler(option.field);
    } else {
      changeHandler(null);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_mlFieldStatsFlyout.OptionListWithFieldStats, {
    singleSelection: true,
    options: options,
    selectedOptions: selection,
    onChange: onChange,
    isClearable: isClearable,
    placeholder: placeholder,
    "data-test-subj": testSubject,
    titleId: titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  });
};
exports.SplitFieldSelect = SplitFieldSelect;