"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _new_job = require("../../../../../../../../../common/constants/new_job");
var _split_cards = require("../split_cards");
var _detector_title = require("../detector_title");
var _by_field = require("../by_field");
var _anomaly_chart = require("../../../charts/anomaly_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/population_view/chart_grid.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ChartGrid = ({
  aggFieldPairList,
  chartSettings,
  splitField,
  lineChartsData,
  modelData,
  anomalyData,
  deleteDetector,
  jobType,
  fieldValuesPerDetector,
  loading = false
}) => {
  const animateSplit = (0, _split_cards.useAnimateSplit)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: chartSettings.cols,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, aggFieldPairList.map((af, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: i,
    "data-test-subj": `mlDetector ${i}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_detector_title.DetectorTitle, {
    index: i,
    agg: aggFieldPairList[i].agg,
    field: aggFieldPairList[i].field,
    byField: aggFieldPairList[i].by,
    deleteDetector: deleteDetector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 17
    }
  }, deleteDetector !== undefined && /*#__PURE__*/_react.default.createElement(_by_field.ByFieldSelector, {
    detectorIndex: i,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 52
    }
  })), jobType === _new_job.JOB_TYPE.POPULATION && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 53
    }
  }))), /*#__PURE__*/_react.default.createElement(_split_cards.SplitCards, {
    fieldValues: fieldValuesPerDetector[i] || [],
    splitField: splitField,
    numberOfDetectors: aggFieldPairList.length,
    jobType: jobType,
    animate: animateSplit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_anomaly_chart.AnomalyChart, {
    chartType: _anomaly_chart.CHART_TYPE.SCATTER,
    chartData: lineChartsData[i],
    modelData: modelData[i],
    anomalyData: anomalyData[i],
    height: chartSettings.height,
    width: chartSettings.width,
    loading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 15
    }
  }))))));
};
exports.ChartGrid = ChartGrid;