"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RareCard = exports.HighCountCard = exports.CountCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/categorization_detector/detector_cards.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CountCard = ({
  onClick,
  isSelected
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 20,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
  "data-test-subj": `mlJobWizardCategorizationDetectorCountCard${isSelected ? ' selected' : ''}`,
  title: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.categorizationDetectorSelect.countCard.title', {
    defaultMessage: 'Count'
  }),
  description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.categorizationDetectorSelect.countCard.description",
    defaultMessage: "Look for anomalies in the event rate of a category.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.categorizationDetectorSelect.countCard.description2",
    defaultMessage: "Recommended for categorizing all messages.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 11
    }
  })),
  selectable: {
    onClick,
    isSelected
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 21,
    columnNumber: 5
  }
}));
exports.CountCard = CountCard;
const HighCountCard = ({
  onClick,
  isSelected
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 50,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
  "data-test-subj": `mlJobWizardCategorizationDetectorHighCountCard${isSelected ? ' selected' : ''}`,
  title: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.categorizationDetectorSelect.highCountCard.title', {
    defaultMessage: 'High count'
  }),
  description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.categorizationDetectorSelect.highCountCard.description",
    defaultMessage: "Look for unusually high counts of a category in the event rate.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.categorizationDetectorSelect.highCountCard.description2",
    defaultMessage: "Recommended for categorizing error messages.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  })),
  selectable: {
    onClick,
    isSelected
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 5
  }
}));
exports.HighCountCard = HighCountCard;
const RareCard = ({
  onClick,
  isSelected
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 82,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
  "data-test-subj": `mlJobWizardCategorizationDetectorRareCard${isSelected ? ' selected' : ''}`,
  title: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.categorizationDetectorSelect.rareCard.title', {
    defaultMessage: 'Rare'
  }),
  description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.categorizationDetectorSelect.rareCard.description",
    defaultMessage: "Look for categories that occur rarely in time.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  })),
  selectable: {
    onClick,
    isSelected
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 83,
    columnNumber: 5
  }
}));
exports.RareCard = RareCard;