"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModelPlotSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _job_creator_context = require("../../../../../job_creator_context");
var _description = require("./description");
var _mml_callout = require("../mml_callout");
var _job_creator = require("../../../../../../../common/job_creator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/job_details_step/components/advanced_section/components/model_plot/model_plot_switch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ModelPlotSwitch = () => {
  const {
    jobCreator,
    jobCreatorUpdate,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [modelPlotEnabled, setModelPlotEnabled] = (0, _react.useState)(jobCreator.modelPlot);
  const [enabled, setEnabled] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    jobCreator.modelPlot = modelPlotEnabled;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [modelPlotEnabled]);
  (0, _react.useEffect)(() => {
    const aggs = [_mlAnomalyUtils.ML_JOB_AGGREGATION.RARE];
    // disable model plot switch if the wizard is creating a categorization job
    // and a rare detector is being used.
    const isRareCategoryJob = (0, _job_creator.isCategorizationJobCreator)(jobCreator) && jobCreator.aggregations.some(agg => aggs.includes(agg.id));
    setEnabled(isRareCategoryJob === false);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  function toggleModelPlot() {
    setModelPlotEnabled(!modelPlotEnabled);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_description.Description, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "switch",
    disabled: enabled === false,
    checked: modelPlotEnabled,
    onChange: toggleModelPlot,
    "data-test-subj": "mlJobWizardSwitchModelPlot",
    label: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobDetailsStep.advancedSection.enableModelPlot.title', {
      defaultMessage: 'Enable model plot'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_mml_callout.MMLCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }));
};
exports.ModelPlotSwitch = ModelPlotSwitch;