"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeRangePicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/common/components/time_range_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WIDTH = '512px';
const TimeRangePicker = ({
  setTimeRange,
  timeRange
}) => {
  const {
    services: {
      uiSettings
    }
  } = (0, _kibana.useMlKibana)();
  // TODO should use fieldFormats instead
  const dateFormat = uiSettings.get('dateFormat');
  const [startMoment, setStartMoment] = (0, _react.useState)((0, _moment.default)(timeRange.start));
  const [endMoment, setEndMoment] = (0, _react.useState)((0, _moment.default)(timeRange.end));
  function handleChangeStart(date) {
    setStartMoment(date || undefined);
  }
  function handleChangeEnd(date) {
    setEndMoment(date || undefined);
  }

  // update the parent start and end if the timepicker changes
  (0, _react.useEffect)(() => {
    if (startMoment !== undefined && endMoment !== undefined) {
      setTimeRange({
        start: startMoment.valueOf(),
        end: endMoment.valueOf()
      });
    }
  }, [startMoment, endMoment, setTimeRange]);

  // update our local start and end moment objects if
  // the parent start and end updates.
  // this happens if the use full data button is pressed.
  (0, _react.useEffect)(() => {
    setStartMoment((0, _moment.default)(timeRange.start));
    setEndMoment((0, _moment.default)(timeRange.end));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [JSON.stringify(timeRange)]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      minWidth: WIDTH
    },
    "data-test-subj": `mlJobWizardDateRange`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePickerRange, {
    fullWidth: true,
    startDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      popperProps: {
        'data-test-subj': 'mlJobWizardDatePickerRangeStartDate'
      },
      selected: startMoment,
      onChange: handleChangeStart,
      startDate: startMoment,
      endDate: endMoment,
      "aria-label": _i18n.i18n.translate('xpack.ml.newJob.wizard.timeRangeStep.timeRangePicker.startDateLabel', {
        defaultMessage: 'Start date'
      }),
      showTimeSelect: true,
      dateFormat: dateFormat,
      maxDate: endMoment,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 13
      }
    }),
    endDateControl: /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      popperProps: {
        'data-test-subj': 'mlJobWizardDatePickerRangeEndDate'
      },
      selected: endMoment,
      onChange: handleChangeEnd,
      startDate: startMoment,
      endDate: endMoment,
      "aria-label": _i18n.i18n.translate('xpack.ml.newJob.wizard.timeRangeStep.timeRangePicker.endDateLabel', {
        defaultMessage: 'End date'
      }),
      showTimeSelect: true,
      dateFormat: dateFormat,
      minDate: startMoment,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  })));
};
exports.TimeRangePicker = TimeRangePicker;