"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditDatafeedTab = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlParseInterval = require("@kbn/ml-parse-interval");
var _job_utils = require("../../../../../../../common/util/job_utils");
var _ml_server_info = require("../../../../../services/ml_server_info");
var _ml_job_editor = require("../../ml_job_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/edit_job_flyout/tabs/edit_datafeed_tab.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getDefaults(bucketSpan, jobDefaults) {
  const bucketSpanSeconds = bucketSpan !== undefined ? (0, _mlParseInterval.parseInterval)(bucketSpan).asSeconds() : '';
  return {
    queryDelay: '60s',
    frequency: (0, _job_utils.calculateDatafeedFrequencyDefaultSeconds)(bucketSpanSeconds) + 's',
    scrollSize: jobDefaults.datafeeds.scroll_size
  };
}
class EditDatafeedTab extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onQueryChange", query => {
      this.setDatafeed({
        datafeedQuery: query
      });
    });
    (0, _defineProperty2.default)(this, "onQueryDelayChange", e => {
      this.setDatafeed({
        datafeedQueryDelay: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onFrequencyChange", e => {
      this.setDatafeed({
        datafeedFrequency: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onScrollSizeChange", e => {
      this.setDatafeed({
        datafeedScrollSize: +e.target.value
      });
    });
    this.state = {
      query: '',
      queryDelay: '',
      frequency: '',
      scrollSize: '',
      defaults: {
        queryDelay: '',
        frequency: '',
        scrollSize: 0
      },
      jobDefaults: (0, _ml_server_info.getNewJobDefaults)()
    };
    this.setDatafeed = props.setDatafeed;
  }
  static getDerivedStateFromProps(props, state) {
    return {
      query: props.datafeedQuery,
      queryDelay: props.datafeedQueryDelay,
      frequency: props.datafeedFrequency,
      scrollSize: props.datafeedScrollSize,
      defaults: getDefaults(props.jobBucketSpan, state.jobDefaults)
    };
  }
  render() {
    const {
      query,
      queryDelay,
      frequency,
      scrollSize,
      defaults
    } = this.state;
    const {
      datafeedRunning
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 9
      }
    }), datafeedRunning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.editJobFlyout.datafeed.readOnlyCalloutText",
      defaultMessage: "Datafeed settings cannot be edited while the datafeed is running. Please stop the job if you wish to edit these settings.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.datafeed.queryLabel",
        defaultMessage: "Query",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 15
        }
      }),
      style: {
        maxWidth: 'inherit'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_ml_job_editor.MLJobEditor, {
      mode: _ml_job_editor.ML_EDITOR_MODE.XJSON,
      value: query,
      onChange: this.onQueryChange,
      height: "200px",
      readOnly: datafeedRunning,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.datafeed.queryDelayLabel",
        defaultMessage: "Query delay",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 15
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: queryDelay,
      placeholder: defaults.queryDelay,
      onChange: this.onQueryDelayChange,
      disabled: datafeedRunning,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.datafeed.frequencyLabel",
        defaultMessage: "Frequency",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 15
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: frequency,
      placeholder: defaults.frequency,
      onChange: this.onFrequencyChange,
      disabled: datafeedRunning,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.datafeed.scrollSizeLabel",
        defaultMessage: "Scroll size",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 15
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: scrollSize,
      placeholder: defaults.scrollSize,
      onChange: this.onScrollSizeChange,
      disabled: datafeedRunning,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 13
      }
    }))));
  }
}
exports.EditDatafeedTab = EditDatafeedTab;
EditDatafeedTab.propTypes = {
  datafeedRunning: _propTypes.default.bool.isRequired,
  datafeedQuery: _propTypes.default.string.isRequired,
  datafeedQueryDelay: _propTypes.default.string.isRequired,
  datafeedFrequency: _propTypes.default.string.isRequired,
  datafeedScrollSize: _propTypes.default.number.isRequired,
  jobBucketSpan: _propTypes.default.string.isRequired,
  setDatafeed: _propTypes.default.func.isRequired
};