"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsSummary = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _const = require("./const");
var _render_cell_value = require("../../../alerting/anomaly_detection_alerts_table/render_cell_value");
var _kibana = require("../../contexts/kibana");
var _anomaly_explorer_context = require("../anomaly_explorer_context");
var _get_alerts_summary = require("./get_alerts_summary");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/alerts/alerts_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PAGE_SIZE = 3;
const AlertsSummary = () => {
  const {
    services: {
      fieldFormats
    }
  } = (0, _kibana.useMlKibana)();
  const {
    anomalyDetectionAlertsStateService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const alertsData = (0, _useObservable.default)(anomalyDetectionAlertsStateService.anomalyDetectionAlerts$, []);
  const formatter = (0, _render_cell_value.getAlertFormatters)(fieldFormats);
  const [activePage, setActivePage] = (0, _react.useState)(0);
  const sortedAlertsByRule = (0, _react.useMemo)(() => {
    return (0, _get_alerts_summary.getAlertsSummary)(alertsData);
  }, [alertsData]);
  const pageItems = (0, _react.useMemo)(() => {
    return sortedAlertsByRule.slice(activePage * PAGE_SIZE, (activePage + 1) * PAGE_SIZE);
  }, [activePage, sortedAlertsByRule]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3,
    gutterSize: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, pageItems.map(([ruleName, ruleSummary]) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: ruleName,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: 'xs',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 21
      }
    }, ruleName))), ruleSummary.activeCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "accent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 21
      }
    }, _const.statusNameMap.active)) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: true,
      type: "column",
      listItems: [{
        title: _i18n.i18n.translate('xpack.ml.explorer.alertsPanel.summary.totalAlerts', {
          defaultMessage: 'Total alerts: '
        }),
        description: ruleSummary.totalCount
      }, ...(ruleSummary.activeCount > 0 ? [{
        title: _i18n.i18n.translate('xpack.ml.explorer.alertsPanel.summary.startedAt', {
          defaultMessage: 'Started at: '
        }),
        description: formatter(_ruleDataUtils.ALERT_END, ruleSummary.startedAt)
      }] : [{
        title: _i18n.i18n.translate('xpack.ml.explorer.alertsPanel.summary.recoveredAt', {
          defaultMessage: 'Recovered at: '
        }),
        description: formatter(_ruleDataUtils.ALERT_END, ruleSummary.recoveredAt)
      }]), {
        title: _i18n.i18n.translate('xpack.ml.explorer.alertsPanel.summary.lastDuration', {
          defaultMessage: 'Last duration: '
        }),
        description: formatter(_ruleDataUtils.ALERT_DURATION, ruleSummary.lastDuration)
      }],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 15
      }
    }));
  })), sortedAlertsByRule.length > PAGE_SIZE ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": _i18n.i18n.translate('xpack.ml.explorer.alertsPanel.summary.paginationAreaLabel', {
      defaultMessage: 'Alerting rules pagination'
    }),
    pageCount: Math.ceil(sortedAlertsByRule.length / PAGE_SIZE),
    activePage: activePage,
    onPageClick: setActivePage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  }))) : null);
};
exports.AlertsSummary = AlertsSummary;