"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _check_capabilities = require("../../../../../capabilities/check_capabilities");
var _delete_space_aware_item_check_modal = require("../../../../../components/delete_space_aware_item_check_modal");
var _action_clone = require("../action_clone");
var _action_delete = require("../action_delete");
var _action_edit = require("../action_edit");
var _action_start = require("../action_start");
var _action_stop = require("../action_stop");
var _action_view = require("../action_view");
var _action_map = require("../action_map");
var _analytics = require("../../../../common/analytics");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/components/analytics_list/use_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const useActions = () => {
  var _deleteAction$item;
  const [canCreateDataFrameAnalytics, canDeleteDataFrameAnalytics, canStartStopDataFrameAnalytics] = (0, _check_capabilities.usePermissionCheck)(['canCreateDataFrameAnalytics', 'canDeleteDataFrameAnalytics', 'canStartStopDataFrameAnalytics']);
  const viewAction = (0, _action_view.useViewAction)();
  const mapAction = (0, _action_map.useMapAction)();
  const cloneAction = (0, _action_clone.useCloneAction)(canCreateDataFrameAnalytics);
  const deleteAction = (0, _action_delete.useDeleteAction)(canDeleteDataFrameAnalytics);
  const editAction = (0, _action_edit.useEditAction)(canStartStopDataFrameAnalytics);
  const startAction = (0, _action_start.useStartAction)(canStartStopDataFrameAnalytics);
  const stopAction = (0, _action_stop.useStopAction)(canStartStopDataFrameAnalytics);
  const {
    refresh
  } = (0, _analytics.useRefreshAnalyticsList)();
  const actions = [viewAction.action, mapAction.action];
  const modals = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, startAction.isModalVisible && /*#__PURE__*/_react.default.createElement(_action_start.StartActionModal, (0, _extends2.default)({}, startAction, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 38
    }
  })), stopAction.isModalVisible && /*#__PURE__*/_react.default.createElement(_action_stop.StopActionModal, (0, _extends2.default)({}, stopAction, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 37
    }
  })), deleteAction.isDeleteJobCheckModalVisible && (deleteAction === null || deleteAction === void 0 ? void 0 : (_deleteAction$item = deleteAction.item) === null || _deleteAction$item === void 0 ? void 0 : _deleteAction$item.config) && /*#__PURE__*/_react.default.createElement(_delete_space_aware_item_check_modal.DeleteSpaceAwareItemCheckModal, {
    onCloseCallback: deleteAction.closeDeleteJobCheckModal,
    canDeleteCallback: () => {
      // Item will always be set by the time we open the delete modal
      deleteAction.openModal(deleteAction.item);
      deleteAction.closeDeleteJobCheckModal();
    },
    refreshJobsCallback: refresh,
    mlSavedObjectType: deleteAction.jobType,
    ids: [deleteAction.item.config.id],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }), deleteAction.isModalVisible && /*#__PURE__*/_react.default.createElement(_action_delete.DeleteActionModal, (0, _extends2.default)({}, deleteAction, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 39
    }
  })), (0, _action_edit.isEditActionFlyoutVisible)(editAction) && /*#__PURE__*/_react.default.createElement(_action_edit.EditActionFlyout, (0, _extends2.default)({}, editAction, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 49
    }
  })));
  actions.push(...[startAction.action, stopAction.action, editAction.action, cloneAction.action, deleteAction.action]);
  return {
    actions,
    modals
  };
};
exports.useActions = useActions;