"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorationPageWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _scatterplot_matrix = require("../../../../../components/scatterplot_matrix");
var _common = require("../../../../common");
var _expandable_section = require("../expandable_section");
var _exploration_results_table = require("../exploration_results_table");
var _exploration_query_bar = require("../exploration_query_bar");
var _job_config_error_callout = require("../job_config_error_callout");
var _loading_panel = require("../loading_panel");
var _use_exploration_url_state = require("../../hooks/use_exploration_url_state");
var _data_view_prompt = require("../data_view_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_exploration/components/exploration_page_wrapper/exploration_page_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getFilters(resultsField) {
  return {
    options: [{
      id: 'training',
      label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationResults.trainingSubsetLabel', {
        defaultMessage: 'Training'
      })
    }, {
      id: 'testing',
      label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationResults.testingSubsetLabel', {
        defaultMessage: 'Testing'
      })
    }],
    columnId: `${resultsField}.is_training`,
    key: {
      training: true,
      testing: false
    }
  };
}
const ExplorationPageWrapper = ({
  jobId,
  title,
  EvaluatePanel,
  FeatureImportanceSummaryPanel
}) => {
  var _jobConfig$dest$resul, _jobConfig$analyzed_f, _jobConfig$analyzed_f2;
  const {
    dataView,
    dataViewErrorMessage,
    isInitialized,
    isLoadingJobConfig,
    jobCapsServiceErrorMessage,
    jobConfig,
    jobConfigErrorMessage,
    jobStatus,
    needsDestDataView,
    totalFeatureImportance
  } = (0, _common.useResultsViewConfig)(jobId);
  const [pageUrlState, setPageUrlState] = (0, _use_exploration_url_state.useExplorationUrlState)();
  const [searchQuery, setSearchQuery] = (0, _react.useState)(_common.defaultSearchQuery);
  const searchQueryUpdateHandler = (0, _react.useCallback)(update => {
    if (update.query) {
      setSearchQuery(update.query);
    }
    if (update.queryString !== pageUrlState.queryText) {
      setPageUrlState({
        queryText: update.queryString,
        queryLanguage: update.language
      });
    }
  }, [pageUrlState, setPageUrlState]);
  const query = {
    query: pageUrlState.queryText,
    language: pageUrlState.queryLanguage
  };
  const resultsField = (_jobConfig$dest$resul = jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.dest.results_field) !== null && _jobConfig$dest$resul !== void 0 ? _jobConfig$dest$resul : '';
  const destIndex = (0, _common.getDestinationIndex)(jobConfig);
  const scatterplotFieldOptions = (0, _scatterplot_matrix.useScatterplotFieldOptions)(dataView, jobConfig === null || jobConfig === void 0 ? void 0 : (_jobConfig$analyzed_f = jobConfig.analyzed_fields) === null || _jobConfig$analyzed_f === void 0 ? void 0 : _jobConfig$analyzed_f.includes, jobConfig === null || jobConfig === void 0 ? void 0 : (_jobConfig$analyzed_f2 = jobConfig.analyzed_fields) === null || _jobConfig$analyzed_f2 === void 0 ? void 0 : _jobConfig$analyzed_f2.excludes, resultsField);
  if (dataViewErrorMessage !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.exploration.indexError', {
        defaultMessage: 'An error occurred loading the index data.'
      }),
      color: "danger",
      iconType: "cross",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 11
      }
    }, dataViewErrorMessage, needsDestDataView ? /*#__PURE__*/_react.default.createElement(_data_view_prompt.DataViewPrompt, {
      destIndex: destIndex,
      color: "text",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 34
      }
    }) : null)));
  }
  if (jobConfigErrorMessage !== undefined || jobCapsServiceErrorMessage !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_job_config_error_callout.JobConfigErrorCallout, {
      jobCapsServiceErrorMessage: jobCapsServiceErrorMessage,
      jobConfigErrorMessage: jobConfigErrorMessage,
      title: title,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 7
      }
    });
  }
  const jobType = jobConfig && jobConfig.analysis ? (0, _mlDataFrameAnalyticsUtils.getAnalysisType)(jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.analysis) : undefined;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, typeof (jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.description) !== 'undefined' && (jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.description) !== '' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }, jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  })), dataView !== undefined && jobConfig && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_exploration_query_bar.ExplorationQueryBar, {
    dataView: dataView,
    setSearchQuery: searchQueryUpdateHandler,
    query: query,
    filters: getFilters(jobConfig.dest.results_field),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  })), isLoadingJobConfig === true && jobConfig === undefined && /*#__PURE__*/_react.default.createElement(_loading_panel.LoadingPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 66
    }
  }), isLoadingJobConfig === false && jobConfig !== undefined && isInitialized === true && /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSectionAnalytics, {
    jobId: jobConfig.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 9
    }
  }), isLoadingJobConfig === true && jobConfig === undefined && /*#__PURE__*/_react.default.createElement(_loading_panel.LoadingPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 66
    }
  }), isLoadingJobConfig === false && jobConfig !== undefined && isInitialized === true && /*#__PURE__*/_react.default.createElement(EvaluatePanel, {
    jobConfig: jobConfig,
    jobStatus: jobStatus,
    searchQuery: searchQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  }), isLoadingJobConfig === true && jobConfig !== undefined && totalFeatureImportance === undefined && /*#__PURE__*/_react.default.createElement(_loading_panel.LoadingPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 49
    }
  }), isLoadingJobConfig === false && jobConfig !== undefined && totalFeatureImportance !== undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FeatureImportanceSummaryPanel, {
    totalFeatureImportance: totalFeatureImportance,
    jobConfig: jobConfig,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }), isLoadingJobConfig === true && jobConfig === undefined && /*#__PURE__*/_react.default.createElement(_loading_panel.LoadingPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 66
    }
  }), isLoadingJobConfig === false && jobConfig !== undefined && isInitialized === true && typeof (jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.id) === 'string' && scatterplotFieldOptions.length > 1 && typeof (jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.analysis) !== 'undefined' && /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSectionSplom, {
    fields: scatterplotFieldOptions,
    index: jobConfig === null || jobConfig === void 0 ? void 0 : jobConfig.dest.index,
    dataView: dataView,
    color: jobType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION || jobType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.CLASSIFICATION ? (0, _mlDataFrameAnalyticsUtils.getDependentVar)(jobConfig.analysis) : undefined,
    legendType: (0, _common.getScatterplotMatrixLegendType)(jobType),
    searchQuery: searchQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 11
    }
  }), isLoadingJobConfig === true && jobConfig === undefined && /*#__PURE__*/_react.default.createElement(_loading_panel.LoadingPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 66
    }
  }), isLoadingJobConfig === false && jobConfig !== undefined && dataView !== undefined && isInitialized === true && /*#__PURE__*/_react.default.createElement(_exploration_results_table.ExplorationResultsTable, {
    dataView: dataView,
    jobConfig: jobConfig,
    jobStatus: jobStatus,
    needsDestDataView: needsDestDataView,
    searchQuery: searchQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 11
    }
  }));
};
exports.ExplorationPageWrapper = ExplorationPageWrapper;