"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewResultsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../contexts/kibana");
var _locator = require("../../../../../../../common/constants/locator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/view_results_panel/view_results_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ViewResultsPanel = ({
  jobId,
  analysisType
}) => {
  const analyticsExplorationPageLink = (0, _kibana.useMlLink)({
    page: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_EXPLORATION,
    pageState: {
      jobId,
      analysisType
    }
  });
  const {
    euiTheme: {
      size
    }
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    css: {
      width: `calc(${size.xxl} * 7.5)`
    },
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "visTable",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 15
      }
    }),
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.viewResultsCardTitle', {
      defaultMessage: 'View Results'
    }),
    description: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.viewResultsCardDescription', {
      defaultMessage: 'View results for the analytics job.'
    }),
    href: analyticsExplorationPageLink,
    "data-test-subj": "analyticsWizardViewResultsCard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }));
};
exports.ViewResultsPanel = ViewResultsPanel;