"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPermissionsCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../contexts/kibana");
var _hooks = require("../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/index_permissions_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IndexPermissionsCallout = ({
  indexName,
  docsType
}) => {
  const {
    services: {
      docLinks: {
        links: {
          ml: {
            dFAStartJob,
            dFACreateJob
          }
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  const docsLink = docsType === 'start' ? dFAStartJob : dFACreateJob;
  const hasRequiredIndicesPermissions = (0, _hooks.useHasRequiredIndicesPermissions)(indexName, docsType === 'start');
  // If 'hasRequiredIndicesPermissions' is undefined - the index passed to the check is an empty string
  if (hasRequiredIndicesPermissions === undefined || hasRequiredIndicesPermissions === true) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.permissionsCalloutTitle', {
      defaultMessage: 'Indices permissions required'
    }),
    iconType: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.create.indicesPermissionsMessage",
    defaultMessage: "You don't have the required permissions on the {indexName} index. Refer to the {docLink} for more information on requirements.",
    values: {
      indexName,
      docLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docsLink,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.dataframe.analytics.create.indicesPermissionsMessage.docsLink",
        defaultMessage: "documentation",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 19
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }));
};
exports.IndexPermissionsCallout = IndexPermissionsCallout;