"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsStepForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _create_data_view_form_row = require("@kbn/ml-data-view-utils/components/create_data_view_form_row");
var _destination_index_form = require("@kbn/ml-creation-wizard-utils/components/destination_index_form");
var _mlValidators = require("@kbn/ml-validators");
var _kibana = require("../../../../../contexts/kibana");
var _continue_button = require("../continue_button");
var _page = require("../../page");
var _use_can_create_data_view = require("../../hooks/use_can_create_data_view");
var _use_data_view_time_fields = require("../../hooks/use_data_view_time_fields");
var _additional_section = require("./additional_section");
var _index_permissions_callout = require("../index_permissions_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/details_step/details_step_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_RESULTS_FIELD = 'ml';
const indexNameExistsMessage = _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.destinationIndexHelpText', {
  defaultMessage: 'An index with this name already exists. Be aware that running this analytics job will modify this destination index.'
});
const DetailsStepForm = ({
  actions,
  state,
  setCurrentStep
}) => {
  const {
    services: {
      docLinks,
      notifications
    }
  } = (0, _kibana.useMlKibana)();
  const mlApi = (0, _kibana.useMlApi)();
  const canCreateDataView = (0, _use_can_create_data_view.useCanCreateDataView)();
  const {
    dataViewAvailableTimeFields,
    onTimeFieldChanged
  } = (0, _use_data_view_time_fields.useDataViewTimeFields)({
    actions,
    state
  });
  const createIndexLink = docLinks.links.apis.createIndex;
  const {
    setFormState
  } = actions;
  const {
    form,
    cloneJob,
    hasSwitchedToEditor,
    isJobCreated
  } = state;
  const {
    createDataView,
    description,
    destinationDataViewTitleExists,
    destinationIndex,
    destinationIndexNameEmpty,
    destinationIndexNameExists,
    destinationIndexNameValid,
    jobId,
    jobIdEmpty,
    jobIdExists,
    jobIdInvalidMaxLength,
    jobIdValid,
    resultsField,
    timeFieldName
  } = form;
  const [destIndexSameAsId, setDestIndexSameAsId] = (0, _react.useState)(hasSwitchedToEditor === false && destinationIndex !== undefined && destinationIndex === jobId);
  const [useResultsFieldDefault, setUseResultsFieldDefault] = (0, _react.useState)(cloneJob === undefined && hasSwitchedToEditor === false && resultsField === undefined || cloneJob !== undefined && resultsField === DEFAULT_RESULTS_FIELD);
  const forceInput = (0, _react.useRef)(null);
  const isStepInvalid = jobIdEmpty === true || jobIdExists === true || jobIdValid === false || destinationIndexNameEmpty === true || destinationIndexNameValid === false || createDataView && destinationDataViewTitleExists === true;
  const debouncedIndexCheck = (0, _lodash.debounce)(async () => {
    try {
      const resp = await mlApi.checkIndicesExists({
        indices: [destinationIndex]
      });
      setFormState({
        destinationIndexNameExists: resp[destinationIndex].exists
      });
    } catch (e) {
      notifications.toasts.addDanger(_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.errorCheckingIndexExists', {
        defaultMessage: 'The following error occurred getting the existing index names: {error}',
        values: {
          error: (0, _mlErrorUtils.extractErrorMessage)(e)
        }
      }));
    }
  }, 400);
  const debouncedJobIdCheck = (0, _react.useMemo)(() => (0, _lodash.debounce)(async () => {
    try {
      const results = await mlApi.dataFrameAnalytics.jobsExist([jobId], true);
      setFormState({
        jobIdExists: results[jobId].exists
      });
    } catch (e) {
      notifications.toasts.addDanger(_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.errorCheckingJobIdExists', {
        defaultMessage: 'The following error occurred checking if job id exists: {error}',
        values: {
          error: (0, _mlErrorUtils.extractErrorMessage)(e)
        }
      }));
    }
  }, 400),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [jobId]);
  (0, _react.useEffect)(() => {
    if (jobIdValid === true) {
      debouncedJobIdCheck();
    } else if (typeof jobId === 'string' && jobId.trim() === '' && jobIdExists === true) {
      setFormState({
        jobIdExists: false
      });
    }
    return () => {
      debouncedJobIdCheck.cancel();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobId]);
  (0, _react.useEffect)(() => {
    if (destinationIndexNameValid === true) {
      debouncedIndexCheck();
    } else if (typeof destinationIndex === 'string' && destinationIndex.trim() === '' && destinationIndexNameExists === true) {
      setFormState({
        destinationIndexNameExists: false
      });
    }
    return () => {
      debouncedIndexCheck.cancel();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [destinationIndex]);
  (0, _react.useEffect)(() => {
    if (destIndexSameAsId === true && !jobIdEmpty && jobIdValid) {
      setFormState({
        destinationIndex: jobId
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [destIndexSameAsId, jobId]);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_index_permissions_callout.IndexPermissionsCallout, {
    indexName: destinationIndex,
    docsType: "start",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.jobIdLabel', {
      defaultMessage: 'Job ID'
    }),
    isInvalid: !jobIdEmpty && !jobIdValid || jobIdExists || jobIdInvalidMaxLength,
    error: [...(!jobIdEmpty && !jobIdValid ? [_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.jobIdInvalidError', {
      defaultMessage: 'Must contain lowercase alphanumeric characters (a-z and 0-9), hyphens, and underscores only and must start and end with alphanumeric characters.'
    })] : []), ...(jobIdExists ? [_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.jobIdExistsError', {
      defaultMessage: 'An analytics job with this ID already exists.'
    })] : []), ...(jobIdInvalidMaxLength ? [_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.jobIdInvalidMaxLengthErrorMessage', {
      defaultMessage: 'Job ID must be no more than {maxLength, plural, one {# character} other {# characters}} long.',
      values: {
        maxLength: _mlValidators.JOB_ID_MAX_LENGTH
      }
    })] : [])],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    inputRef: input => {
      if (input) {
        forceInput.current = input;
      }
    },
    disabled: isJobCreated,
    placeholder: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.jobIdPlaceholder', {
      defaultMessage: 'Job ID'
    }),
    value: jobId,
    onChange: e => setFormState({
      jobId: e.target.value
    }),
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.jobIdInputAriaLabel', {
      defaultMessage: 'Choose a unique analytics job ID.'
    }),
    isInvalid: !jobIdEmpty && !jobIdValid || jobIdExists || jobIdInvalidMaxLength || jobIdEmpty,
    "data-test-subj": "mlAnalyticsCreateJobFlyoutJobIdInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.jobDescription.label', {
      defaultMessage: 'Job description'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    fullWidth: true,
    value: description,
    placeholder: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.jobDescription.helpText', {
      defaultMessage: 'Optional descriptive text'
    }),
    rows: 2,
    onChange: e => {
      const value = e.target.value;
      setFormState({
        description: value
      });
    },
    "data-test-subj": "mlDFAnalyticsJobCreationJobDescription",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_destination_index_form.DestinationIndexForm, {
    createIndexLink: createIndexLink,
    destinationIndex: destinationIndex,
    destinationIndexNameEmpty: destinationIndexNameEmpty,
    destinationIndexNameExists: destinationIndexNameExists,
    destinationIndexNameValid: destinationIndexNameValid,
    destIndexSameAsId: destIndexSameAsId,
    indexNameExistsMessage: indexNameExistsMessage,
    isJobCreated: isJobCreated,
    onDestinationIndexChange: d => setFormState({
      destinationIndex: d
    }),
    setDestIndexSameAsId: setDestIndexSameAsId,
    switchLabel: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.destinationIndexFormSwitchLabel', {
      defaultMessage: 'Use job ID as destination index name'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    disabled: isJobCreated,
    name: "mlDataFrameAnalyticsUseResultsFieldDefault",
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.UseResultsFieldDefaultLabel', {
      defaultMessage: 'Use results field default value: "{defaultValue}"',
      values: {
        defaultValue: DEFAULT_RESULTS_FIELD
      }
    }),
    checked: useResultsFieldDefault === true,
    onChange: () => {
      if (!useResultsFieldDefault === true) {
        setFormState({
          resultsField: undefined
        });
      }
      setUseResultsFieldDefault(!useResultsFieldDefault);
    },
    "data-test-subj": "mlAnalyticsCreateJobWizardUseResultsFieldDefault",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 9
    }
  })), useResultsFieldDefault === false && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.resultsFieldLabel', {
      defaultMessage: 'Results field'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.resultsFieldHelpText', {
      defaultMessage: 'Define the name of the field in which to store the results of the analysis. Defaults to ml.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: isJobCreated,
    placeholder: "Results field",
    value: resultsField,
    onChange: e => setFormState({
      resultsField: e.target.value
    }),
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.resultsFieldInputAriaLabel', {
      defaultMessage: 'The name of the field in which to store the results of the analysis.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardResultsFieldInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_create_data_view_form_row.CreateDataViewForm, {
    canCreateDataView: canCreateDataView,
    createDataView: createDataView,
    dataViewTitleExists: destinationDataViewTitleExists,
    setCreateDataView: () => setFormState({
      createDataView: !createDataView
    }),
    dataViewAvailableTimeFields: dataViewAvailableTimeFields,
    dataViewTimeField: timeFieldName,
    onTimeFieldChanged: onTimeFieldChanged,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_additional_section.AdditionalSection, {
    formState: state.form,
    setFormState: setFormState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_continue_button.ContinueButton, {
    isDisabled: isStepInvalid,
    onClick: () => {
      setCurrentStep(_page.ANALYTICS_STEPS.VALIDATION);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 7
    }
  }));
};
exports.DetailsStepForm = DetailsStepForm;