"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateAnalyticsAdvancedEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _kibana = require("../../../../../contexts/kibana");
var _create_step = require("../create_step");
var _page = require("../../page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/create_analytics_advanced_editor/create_analytics_advanced_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditorComponent = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./editor_component')))).EditorComponent
}));
const CreateAnalyticsAdvancedEditor = props => {
  const mlApi = (0, _kibana.useMlApi)();
  const {
    actions,
    state
  } = props;
  const {
    setAdvancedEditorRawString,
    setFormState
  } = actions;
  const {
    advancedEditorMessages,
    advancedEditorRawString,
    isJobCreated
  } = state;
  const {
    jobId,
    jobIdEmpty,
    jobIdExists,
    jobIdValid
  } = state.form;
  const forceInput = (0, _react.useRef)(null);
  const {
    toasts
  } = (0, _kibana.useNotifications)();
  const onChange = str => {
    setAdvancedEditorRawString(str);
  };
  const debouncedJobIdCheck = (0, _react.useMemo)(() => (0, _lodash.debounce)(async () => {
    try {
      const results = await mlApi.dataFrameAnalytics.jobsExist([jobId], true);
      setFormState({
        jobIdExists: results[jobId].exists
      });
    } catch (e) {
      toasts.addDanger(_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.advancedEditor.errorCheckingJobIdExists', {
        defaultMessage: 'The following error occurred checking if job id exists: {error}',
        values: {
          error: (0, _mlErrorUtils.extractErrorMessage)(e)
        }
      }));
    }
  }, 400),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [jobId]);

  // Temp effect to close the context menu popover on Clone button click
  (0, _react.useEffect)(() => {
    if (forceInput.current === null) {
      return;
    }
    const evt = document.createEvent('MouseEvents');
    evt.initEvent('mouseup', true, true);
    forceInput.current.dispatchEvent(evt);
  }, []);
  (0, _react.useEffect)(() => {
    if (jobIdValid === true) {
      debouncedJobIdCheck();
    } else if (typeof jobId === 'string' && jobId.trim() === '' && jobIdExists === true) {
      setFormState({
        jobIdExists: false
      });
    }
    return () => {
      debouncedJobIdCheck.cancel();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    className: "mlDataFrameAnalyticsCreateForm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.advancedEditor.jobIdLabel', {
      defaultMessage: 'Analytics job ID'
    }),
    isInvalid: !jobIdEmpty && !jobIdValid || jobIdExists,
    error: [...(!jobIdEmpty && !jobIdValid ? [_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.advancedEditor.jobIdInvalidError', {
      defaultMessage: 'Must contain lowercase alphanumeric characters (a-z and 0-9), hyphens, and underscores only and must start and end with alphanumeric characters.'
    })] : []), ...(jobIdExists ? [_i18n.i18n.translate('xpack.ml.dataframe.analytics.create.advancedEditor.jobIdExistsError', {
      defaultMessage: 'An analytics job with this ID already exists.'
    })] : [])],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    inputRef: input => {
      if (input) {
        forceInput.current = input;
      }
    },
    disabled: isJobCreated,
    placeholder: "analytics job ID",
    value: jobId,
    onChange: e => setFormState({
      jobId: e.target.value
    }),
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.advancedEditor.jobIdInputAriaLabel', {
      defaultMessage: 'Choose a unique analytics job ID.'
    }),
    isInvalid: !jobIdEmpty && !jobIdValid || jobIdExists,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.advancedEditor.configRequestBody', {
      defaultMessage: 'Configuration request body'
    }),
    style: {
      maxWidth: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": 'mlAnalyticsCreateJobWizardAdvancedEditorCodeEditor',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(EditorComponent, {
    value: advancedEditorRawString,
    onChange: onChange,
    readOnly: isJobCreated,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }), advancedEditorMessages.map((advancedEditorMessage, i) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: i,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: advancedEditorMessage.message !== '' ? advancedEditorMessage.message : advancedEditorMessage.error,
    color: advancedEditorMessage.error !== undefined ? 'danger' : 'primary',
    iconType: advancedEditorMessage.error !== undefined ? 'error' : 'checkInCircleFilled',
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, advancedEditorMessage.message !== '' && advancedEditorMessage.error !== undefined ? /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 15
    }
  }, advancedEditorMessage.error) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_create_step.CreateStep, (0, _extends2.default)({}, props, {
    step: _page.ANALYTICS_STEPS.CREATE,
    showCreateDataView: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  })));
};
exports.CreateAnalyticsAdvancedEditor = CreateAnalyticsAdvancedEditor;