"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityControl = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/severity_control/severity_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MAX_ANOMALY_SCORE = 100;
const SeverityControl = exports.SeverityControl = /*#__PURE__*/_react.default.memo(({
  value,
  onChange
}) => {
  const levels = [{
    min: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.LOW,
    max: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MINOR,
    color: _mlAnomalyUtils.ML_SEVERITY_COLORS.WARNING
  }, {
    min: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MINOR,
    max: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MAJOR,
    color: _mlAnomalyUtils.ML_SEVERITY_COLORS.MINOR
  }, {
    min: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MAJOR,
    max: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.CRITICAL,
    color: _mlAnomalyUtils.ML_SEVERITY_COLORS.MAJOR
  }, {
    min: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.CRITICAL,
    max: MAX_ANOMALY_SCORE,
    color: _mlAnomalyUtils.ML_SEVERITY_COLORS.CRITICAL
  }];
  const label = _i18n.i18n.translate('xpack.ml.severitySelector.formControlLabel', {
    defaultMessage: 'Severity'
  });
  const resultValue = value !== null && value !== void 0 ? value : _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.LOW;
  const ticks = new Array(5).fill(null).map((x, i) => {
    const v = i * 25;
    return {
      value: v,
      label: v
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    id: "severityControl",
    style: {
      width: '70px'
    },
    compressed: true,
    prepend: label,
    value: resultValue,
    onChange: e => onChange(Number(e.target.value)),
    min: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.LOW,
    max: MAX_ANOMALY_SCORE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    className: 'mlSeverityControl',
    fullWidth: true,
    min: _mlAnomalyUtils.ML_ANOMALY_THRESHOLD.LOW,
    max: MAX_ANOMALY_SCORE,
    value: resultValue,
    onChange: e => onChange(Number(e.currentTarget.value)),
    "aria-label": _i18n.i18n.translate('xpack.ml.severitySelector.formControlAriaLabel', {
      defaultMessage: 'Select severity threshold'
    }),
    showTicks: true,
    ticks: ticks,
    showRange: false,
    levels: levels,
    "data-test-subj": 'mlAnomalyAlertScoreSelection',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }))));
});