"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VectorTileInspector = exports.RESPONSE_VIEW_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _empty_prompt = require("./empty_prompt");
var _tile_request_tab = require("./tile_request_tab");
var _requests_view_callout = require("./requests_view_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/inspector/vector_tile_adapter/components/vector_tile_inspector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const REQUEST_VIEW_ID = 'request_view';
const RESPONSE_VIEW_ID = exports.RESPONSE_VIEW_ID = 'response_view';
class VectorTileInspector extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_onAdapterChange", () => {
      const layerOptions = this.props.adapters.vectorTiles.getLayerOptions();
      if (layerOptions.length === 0) {
        this.setState({
          selectedLayer: null,
          selectedTileRequest: null,
          tileRequests: [],
          layerOptions: []
        });
        return;
      }
      const selectedLayer = this._getDefaultLayer(layerOptions);
      const tileRequests = this.props.adapters.vectorTiles.getTileRequests(selectedLayer.value);
      this.setState({
        selectedLayer,
        selectedTileRequest: this._getDefaultTileRequest(tileRequests),
        tileRequests,
        layerOptions
      });
    });
    (0, _defineProperty2.default)(this, "_debouncedOnAdapterChange", _lodash.default.debounce(() => {
      if (this._isMounted) {
        this._onAdapterChange();
      }
    }, 256));
    (0, _defineProperty2.default)(this, "_onLayerSelect", selectedOptions => {
      if (selectedOptions.length === 0) {
        this.setState({
          selectedLayer: null,
          selectedTileRequest: null,
          tileRequests: []
        });
        return;
      }
      const selectedLayer = selectedOptions[0];
      const tileRequests = this.props.adapters.vectorTiles.getTileRequests(selectedLayer.value);
      this.setState({
        selectedLayer,
        selectedTileRequest: tileRequests.length ? tileRequests[0] : null,
        tileRequests
      });
    });
    (0, _defineProperty2.default)(this, "_onTileSelect", selectedOptions => {
      if (selectedOptions.length === 0) {
        this.setState({
          selectedTileRequest: null
        });
        return;
      }
      this.setState({
        selectedTileRequest: selectedOptions[0].value ? selectedOptions[0].value : null
      });
    });
    this.state = {
      selectedLayer: null,
      selectedTileRequest: null,
      selectedView: props.options && props.options.initialTab ? props.options.initialTab : REQUEST_VIEW_ID,
      tileRequests: [],
      layerOptions: []
    };
  }
  componentDidMount() {
    this._isMounted = true;
    this._onAdapterChange();
    this.props.adapters.vectorTiles.on('change', this._debouncedOnAdapterChange);
  }
  componentWillUnmount() {
    this._isMounted = false;
    this.props.adapters.vectorTiles.removeListener('change', this._debouncedOnAdapterChange);
  }
  _getDefaultLayer(layerOptions) {
    if (this.state.selectedLayer && layerOptions.some(layerOption => {
      var _this$state$selectedL;
      return ((_this$state$selectedL = this.state.selectedLayer) === null || _this$state$selectedL === void 0 ? void 0 : _this$state$selectedL.value) === layerOption.value;
    })) {
      return this.state.selectedLayer;
    }
    if (this.props.options && this.props.options.initialLayerId) {
      const initialLayer = layerOptions.find(layerOption => {
        return this.props.options.initialLayerId === layerOption.value;
      });
      if (initialLayer) {
        return initialLayer;
      }
    }
    return layerOptions[0];
  }
  _getDefaultTileRequest(tileRequests) {
    if (this.state.selectedTileRequest && tileRequests.some(tileRequest => {
      var _this$state$selectedT, _this$state$selectedT2, _this$state$selectedT3, _this$state$selectedT4;
      return ((_this$state$selectedT = this.state.selectedTileRequest) === null || _this$state$selectedT === void 0 ? void 0 : _this$state$selectedT.layerId) === tileRequest.layerId && ((_this$state$selectedT2 = this.state.selectedTileRequest) === null || _this$state$selectedT2 === void 0 ? void 0 : _this$state$selectedT2.x) === tileRequest.x && ((_this$state$selectedT3 = this.state.selectedTileRequest) === null || _this$state$selectedT3 === void 0 ? void 0 : _this$state$selectedT3.y) === tileRequest.y && ((_this$state$selectedT4 = this.state.selectedTileRequest) === null || _this$state$selectedT4 === void 0 ? void 0 : _this$state$selectedT4.z) === tileRequest.z;
    })) {
      return this.state.selectedTileRequest;
    }
    if (tileRequests.length === 0) {
      return null;
    }
    if (this.props.options && this.props.options.initialTileKey) {
      const initialTileRequest = tileRequests.find(tileRequest => {
        return this.props.options.initialTileKey === `${tileRequest.z}/${tileRequest.x}/${tileRequest.y}`;
      });
      if (initialTileRequest) {
        return initialTileRequest;
      }
    }
    return tileRequests[0];
  }
  _renderTileRequest() {
    if (!this.state.selectedTileRequest) {
      return null;
    }
    if (this.state.selectedView === REQUEST_VIEW_ID) {
      return /*#__PURE__*/_react.default.createElement(_tile_request_tab.TileRequestTab, {
        key: `${this.state.selectedTileRequest.layerId}${this.state.selectedTileRequest.x}${this.state.selectedTileRequest.y}${this.state.selectedTileRequest.z}`,
        tileRequest: this.state.selectedTileRequest,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 189,
          columnNumber: 9
        }
      });
    }
    const tileResponse = getTileResponse(this.state.selectedTileRequest);
    return tileResponse ? /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
      languageId: _monaco.XJsonLang.ID,
      value: JSON.stringify(tileResponse, null, 2),
      options: {
        readOnly: true,
        lineNumbers: 'off',
        fontSize: 12,
        minimap: {
          enabled: false
        },
        folding: true,
        scrollBeyondLastLine: false,
        wordWrap: 'on',
        wrappingIndent: 'indent',
        automaticLayout: true
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.maps.inspector.vectorTile.tileMetaFeatureNotAvailable', {
      defaultMessage: 'Not available'
    })));
  }
  render() {
    return this.state.layerOptions.length === 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_requests_view_callout.RequestsViewCallout, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 9
      }
    })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_requests_view_callout.RequestsViewCallout, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      label: _i18n.i18n.translate('xpack.maps.inspector.vectorTile.layerSelectLabel', {
        defaultMessage: 'Layer'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      fullWidth: true,
      singleSelection: true,
      options: this.state.layerOptions,
      selectedOptions: this.state.selectedLayer ? [this.state.selectedLayer] : [],
      onChange: this._onLayerSelect,
      isClearable: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      label: _i18n.i18n.translate('xpack.maps.inspector.vectorTile.tileSelectLabel', {
        defaultMessage: 'Tile'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      fullWidth: true,
      singleSelection: true,
      options: this.state.tileRequests.map(tileRequest => {
        return {
          label: `${tileRequest.z}/${tileRequest.x}/${tileRequest.y}`,
          value: tileRequest
        };
      }),
      selectedOptions: this.state.selectedTileRequest ? [{
        label: `${this.state.selectedTileRequest.z}/${this.state.selectedTileRequest.x}/${this.state.selectedTileRequest.y}`,
        value: this.state.selectedTileRequest
      }] : [],
      onChange: this._onTileSelect,
      isClearable: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 285,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      onClick: () => {
        this.setState({
          selectedView: REQUEST_VIEW_ID
        });
      },
      isSelected: this.state.selectedView === REQUEST_VIEW_ID,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.maps.inspector.vectorTile.requestTabLabel', {
      defaultMessage: 'Request'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      onClick: () => {
        this.setState({
          selectedView: RESPONSE_VIEW_ID
        });
      },
      isSelected: this.state.selectedView === RESPONSE_VIEW_ID,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 297,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.maps.inspector.vectorTile.responseTabLabel', {
      defaultMessage: 'Response'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 309,
        columnNumber: 9
      }
    }), this._renderTileRequest());
  }
}
exports.VectorTileInspector = VectorTileInspector;
function getTileResponse(tileRequest) {
  if (tileRequest.tileError) {
    return {
      error: tileRequest.tileError.error ? tileRequest.tileError.error : tileRequest.tileError.message
    };
  }
  return tileRequest.tileMetaFeature ? {
    meta: tileRequest.tileMetaFeature.properties
  } : undefined;
}