"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerSettings = LayerSettings;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../common/constants");
var _alpha_slider = require("../../../components/alpha_slider");
var _vector_layer = require("../../../classes/layers/vector_layer");
var _attribution_form_row = require("./attribution_form_row");
var _layer_group = require("../../../classes/layers/layer_group");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/edit_layer_panel/layer_settings/layer_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function LayerSettings(props) {
  const minVisibilityZoom = props.layer.getMinSourceZoom();
  const maxVisibilityZoom = _constants.MAX_ZOOM;
  const layerId = props.layer.getId();
  const onLabelChange = event => {
    const label = event.target.value;
    props.updateLabel(layerId, label);
  };
  const onLocaleChange = event => {
    const {
      value
    } = event.target;
    if (value) props.updateLocale(layerId, value);
  };
  const onZoomChange = value => {
    props.updateMinZoom(layerId, Math.max(minVisibilityZoom, parseInt(value[0], 10)));
    props.updateMaxZoom(layerId, Math.min(maxVisibilityZoom, parseInt(value[1], 10)));
  };
  const onAlphaChange = alpha => {
    props.updateAlpha(layerId, alpha);
  };
  const onLabelsOnTopChange = event => {
    props.updateLabelsOnTop(layerId, event.target.checked);
  };
  const onShowTooltipsChange = event => {
    props.updateDisableTooltips(layerId, !event.target.checked);
  };
  const includeInFitToBoundsChange = event => {
    props.updateIncludeInFitToBounds(layerId, event.target.checked);
  };
  const onAttributionChange = attribution => {
    if (attribution) {
      props.setLayerAttribution(layerId, attribution);
    } else {
      props.clearLayerAttribution(layerId);
    }
  };
  const renderIncludeInFitToBounds = () => {
    if (!props.supportsFitToBounds || (0, _layer_group.isLayerGroup)(props.layer)) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.maps.layerPanel.settingsPanel.fittableFlagTooltip', {
        defaultMessage: `Fit to data bounds adjusts your map extent to show all of your data. Layers may provide reference data and should not be included in the fit to data bounds computation. Use this option to exclude a layer from fit to data bounds computation.`
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.maps.layerPanel.settingsPanel.fittableFlagLabel', {
        defaultMessage: `Include layer in fit to data bounds computation`
      }),
      checked: props.layer.isIncludeInFitToBounds(),
      onChange: includeInFitToBoundsChange,
      "data-test-subj": "mapLayerPanelFittableFlagCheckbox",
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    })));
  };
  const renderZoomSliders = () => {
    return (0, _layer_group.isLayerGroup)(props.layer) ? null : /*#__PURE__*/_react.default.createElement(_public.ValidatedDualRange, {
      label: _i18n.i18n.translate('xpack.maps.layerPanel.settingsPanel.visibleZoomLabel', {
        defaultMessage: 'Visibility'
      }),
      formRowDisplay: "columnCompressed",
      min: minVisibilityZoom,
      max: maxVisibilityZoom,
      value: [props.layer.getMinZoom(), props.layer.getMaxZoom()],
      showInput: "inputWithPopover",
      showRange: true,
      showLabels: true,
      onChange: onZoomChange,
      allowEmptyRange: false,
      compressed: true,
      prepend: _i18n.i18n.translate('xpack.maps.layerPanel.settingsPanel.visibleZoom', {
        defaultMessage: 'Zoom levels'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 7
      }
    });
  };
  const renderLabel = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.layerPanel.settingsPanel.layerNameLabel', {
        defaultMessage: 'Name'
      }),
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: props.layer.getLabel(),
      onChange: onLabelChange,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 9
      }
    }));
  };
  const renderShowLabelsOnTop = () => {
    if (!props.layer.supportsLabelsOnTop()) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.maps.layerPanel.settingsPanel.labelsOnTop', {
        defaultMessage: `Show labels on top`
      }),
      checked: props.layer.areLabelsOnTop(),
      onChange: onLabelsOnTopChange,
      "data-test-subj": "mapLayerPanelApplyGlobalQueryCheckbox",
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 9
      }
    }));
  };
  const renderDisableTooltips = () => {
    return !(0, _vector_layer.isVectorLayer)(props.layer) ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: _i18n.i18n.translate('xpack.maps.layerPanel.settingsPanel.DisableTooltips', {
        defaultMessage: `Show tooltips`
      }),
      disabled: !props.layer.canShowTooltip(),
      checked: !props.layer.areTooltipsDisabled(),
      onChange: onShowTooltipsChange,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 9
      }
    }));
  };
  const renderShowLocaleSelector = () => {
    var _props$layer$getLocal;
    if (!props.layer.supportsLabelLocales()) {
      return null;
    }
    const options = [{
      text: _i18n.i18n.translate('xpack.maps.layerPanel.settingsPanel.labelLanguageAutoselectDropDown', {
        defaultMessage: 'Autoselect based on Kibana locale'
      }),
      value: _constants.AUTOSELECT_EMS_LOCALE
    }, {
      value: 'ar',
      text: 'العربية'
    }, {
      value: 'de',
      text: 'Deutsch'
    }, {
      value: 'en',
      text: 'English'
    }, {
      value: 'es',
      text: 'Español'
    }, {
      value: 'fr-fr',
      text: 'Français'
    }, {
      value: 'hi-in',
      text: 'हिन्दी'
    }, {
      value: 'it',
      text: 'Italiano'
    }, {
      value: 'ja-jp',
      text: '日本語'
    }, {
      value: 'ko',
      text: '한국어'
    }, {
      value: 'pt-pt',
      text: 'Português'
    }, {
      value: 'ru-ru',
      text: 'русский'
    }, {
      value: 'zh-cn',
      text: '简体中文'
    }, {
      text: _i18n.i18n.translate('xpack.maps.layerPanel.settingsPanel.labelLanguageNoneDropDown', {
        defaultMessage: 'None'
      }),
      value: _constants.NO_EMS_LOCALE
    }];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "columnCompressed",
      label: _i18n.i18n.translate('xpack.maps.layerPanel.settingsPanel.labelLanguageLabel', {
        defaultMessage: 'Label language'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      options: options,
      value: (_props$layer$getLocal = props.layer.getLocale()) !== null && _props$layer$getLocal !== void 0 ? _props$layer$getLocal : _constants.NO_EMS_LOCALE,
      onChange: onLocaleChange,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 9
      }
    }));
  };
  const renderLayerGroupInstructions = () => {
    return (0, _layer_group.isLayerGroup)(props.layer) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.maps.layerPanel.settingsPanel.layerGroupCalloutTitle', {
        defaultMessage: 'Drag layers in and out of the group'
      }),
      iconType: "layers",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("ul", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.maps.layerPanel.settingsPanel.layerGroupAddToFront', {
      defaultMessage: 'To add your first layer, drag it onto the group name.'
    })), /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.maps.layerPanel.settingsPanel.layerGroupAddToPosition', {
      defaultMessage: 'To add another layer, drag it anywhere above the last layer in the group.'
    })), /*#__PURE__*/_react.default.createElement("li", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.maps.layerPanel.settingsPanel.layerGroupRemove', {
      defaultMessage: 'To remove a layer, drag it above or below the group.'
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 273,
        columnNumber: 9
      }
    })) : null;
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 5
    }
  }, renderLayerGroupInstructions(), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.layerPanel.layerSettingsTitle",
    defaultMessage: "Layer settings",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 9
    }
  }), renderLabel(), renderZoomSliders(), (0, _layer_group.isLayerGroup)(props.layer) ? null : /*#__PURE__*/_react.default.createElement(_alpha_slider.AlphaSlider, {
    alpha: props.layer.getAlpha(),
    onChange: onAlphaChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 11
    }
  }), renderShowLabelsOnTop(), renderShowLocaleSelector(), (0, _layer_group.isLayerGroup)(props.layer) ? null : /*#__PURE__*/_react.default.createElement(_attribution_form_row.AttributionFormRow, {
    layer: props.layer,
    onChange: onAttributionChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 11
    }
  }), renderIncludeInFitToBounds(), renderDisableTooltips()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 7
    }
  }));
}