"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TermJoinPopoverContent = TermJoinPopoverContent;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _i18n_getters = require("../../../../../../common/i18n_getters");
var _constants = require("../../../../../../common/constants");
var _single_field_select = require("../../../../../components/single_field_select");
var _validated_number_input = require("../../../../../components/validated_number_input");
var _index_pattern_util = require("../../../../../index_pattern_util");
var _kibana_services = require("../../../../../kibana_services");
var _input_strings = require("../../../../input_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/edit_layer_panel/join_editor/resources/term_join_expression/term_join_popover_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TermJoinPopoverContent(props) {
  function onRightDataViewChange(indexPatternId) {
    if (!indexPatternId || indexPatternId.length === 0) {
      return;
    }
    const {
      term,
      ...rest
    } = props.sourceDescriptor;
    props.onSourceDescriptorChange({
      ...rest,
      indexPatternId
    });
  }
  function onLeftFieldChange(selectedFields) {
    var _selectedFields$, _selectedFields$$valu;
    const leftField = selectedFields === null || selectedFields === void 0 ? void 0 : (_selectedFields$ = selectedFields[0]) === null || _selectedFields$ === void 0 ? void 0 : (_selectedFields$$valu = _selectedFields$.value) === null || _selectedFields$$valu === void 0 ? void 0 : _selectedFields$$valu.name;
    if (leftField) {
      props.onLeftFieldChange(leftField);
    }
  }
  function onRightFieldChange(term) {
    if (!term || term.length === 0) {
      return;
    }
    props.onSourceDescriptorChange({
      ...props.sourceDescriptor,
      term
    });
  }
  function renderLeftFieldSelect() {
    const {
      leftValue,
      leftFields
    } = props;
    if (!leftFields) {
      return null;
    }
    const options = leftFields.map(field => {
      return {
        value: field,
        label: field.label
      };
    });
    let leftFieldOption;
    if (leftValue) {
      leftFieldOption = options.find(option => {
        const field = option.value;
        return field.name === leftValue;
      });
    }
    const selectedOptions = leftFieldOption ? [leftFieldOption] : [];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.termJoinExpression.leftFieldLabel', {
        defaultMessage: 'Left field'
      }),
      helpText: _i18n.i18n.translate('xpack.maps.termJoinExpression.leftSourceLabelHelpText', {
        defaultMessage: 'Left source field that contains the shared key.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      placeholder: _input_strings.inputStrings.fieldSelectPlaceholder,
      singleSelection: true,
      isClearable: false,
      options: options,
      selectedOptions: selectedOptions,
      onChange: onLeftFieldChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 9
      }
    }));
  }
  function renderRightSourceSelect() {
    var _props$sourceDescript;
    if (!props.leftValue) {
      return null;
    }
    const IndexPatternSelect = (0, _kibana_services.getIndexPatternSelectComponent)();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.termJoinExpression.rightSourceLabel', {
        defaultMessage: 'Right source'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(IndexPatternSelect, {
      placeholder: (0, _i18n_getters.getDataViewSelectPlaceholder)(),
      indexPatternId: (_props$sourceDescript = props.sourceDescriptor.indexPatternId) !== null && _props$sourceDescript !== void 0 ? _props$sourceDescript : '',
      onChange: onRightDataViewChange,
      isClearable: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 9
      }
    }));
  }
  function renderRightFieldSelect() {
    var _props$sourceDescript2;
    if (!props.rightFields || !props.leftValue) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.termJoinExpression.rightFieldLabel', {
        defaultMessage: 'Right field'
      }),
      helpText: _i18n.i18n.translate('xpack.maps.termJoinExpression.rightSourceLabelHelpText', {
        defaultMessage: 'Right source field that contains the shared key.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
      placeholder: _input_strings.inputStrings.fieldSelectPlaceholder,
      value: (_props$sourceDescript2 = props.sourceDescriptor.term) !== null && _props$sourceDescript2 !== void 0 ? _props$sourceDescript2 : null,
      onChange: onRightFieldChange,
      fields: (0, _index_pattern_util.getTermsFields)(props.rightFields),
      isClearable: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 9
      }
    }));
  }
  function renderRightFieldSizeInput() {
    if (!props.leftValue) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_validated_number_input.ValidatedNumberInput, {
      initialValue: props.sourceDescriptor.size !== undefined ? props.sourceDescriptor.size : _constants.DEFAULT_MAX_BUCKETS_LIMIT,
      min: 1,
      max: _constants.DEFAULT_MAX_BUCKETS_LIMIT,
      onChange: size => {
        props.onSourceDescriptorChange({
          ...props.sourceDescriptor,
          size
        });
      },
      label: _i18n.i18n.translate('xpack.maps.termJoinExpression.rightSizeLabel', {
        defaultMessage: 'Right size'
      }),
      helpText: _i18n.i18n.translate('xpack.maps.termJoinExpression.rightSizeHelpText', {
        defaultMessage: 'Right field term limit.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 7
      }
    });
  }
  const {
    leftSourceName
  } = props;
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.termJoinExpression.popoverTitle",
    defaultMessage: "Configure term join",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormHelpText, {
    className: "mapJoinExpressionHelpText",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.maps.termJoinExpression.helpText",
    defaultMessage: "Configure the shared key that combines layer features, the left source, with the results of an Elasticsearch aggregation, the right source.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.termJoinExpression.leftSourceLabel', {
      defaultMessage: 'Left source'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    selectedOptions: leftSourceName ? [{
      value: leftSourceName,
      label: leftSourceName
    }] : [],
    isDisabled: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 9
    }
  })), renderLeftFieldSelect(), renderRightSourceSelect(), renderRightFieldSelect(), renderRightFieldSizeInput());
}