"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDocValueAndSourceFields = getDocValueAndSourceFields;
var _elasticsearch_util = require("../../../../../common/elasticsearch_util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDocValueAndSourceFields(indexPattern, fieldNames, dateFormat) {
  const docValueFields = [];
  const sourceOnlyFields = [];
  const scriptFields = {};
  fieldNames.forEach(fieldName => {
    const field = (0, _elasticsearch_util.getField)(indexPattern, fieldName);
    if (field.scripted) {
      scriptFields[field.name] = {
        script: {
          source: field.script || '',
          lang: field.lang || ''
        }
      };
    } else if (field.readFromDocValues || field.runtimeField) {
      const docValueField = field.type === 'date' ? {
        field: fieldName,
        format: dateFormat
      } : fieldName;
      docValueFields.push(docValueField);
    } else {
      sourceOnlyFields.push(fieldName);
    }
  });
  return {
    docValueFields,
    sourceOnlyFields,
    scriptFields
  };
}