"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateSourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _metrics_editor = require("../../../components/metrics_editor");
var _kibana_services = require("../../../kibana_services");
var _geo_line_form = require("./geo_line_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/es_geo_line_source/update_source_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class UpdateSourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      indexPattern: null,
      fields: []
    });
    (0, _defineProperty2.default)(this, "_onMetricsChange", metrics => {
      this.props.onChange({
        propName: 'metrics',
        value: metrics
      });
    });
    (0, _defineProperty2.default)(this, "_onGroupByTimeseriesChange", value => {
      this.props.onChange({
        propName: 'groupByTimeseries',
        value
      });
    });
    (0, _defineProperty2.default)(this, "_onLineSimplificationSizeChange", value => {
      this.props.onChange({
        propName: 'lineSimplificationSize',
        value
      });
    });
    (0, _defineProperty2.default)(this, "_onSplitFieldChange", value => {
      this.props.onChange({
        propName: 'splitField',
        value
      });
    });
    (0, _defineProperty2.default)(this, "_onSortFieldChange", value => {
      this.props.onChange({
        propName: 'sortField',
        value
      });
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadFields();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadFields() {
    let indexPattern;
    try {
      indexPattern = await (0, _kibana_services.getIndexPatternService)().get(this.props.indexPatternId);
    } catch (err) {
      return;
    }
    if (!this._isMounted) {
      return;
    }
    this.setState({
      indexPattern,
      fields: indexPattern.fields.filter(field => !_public.indexPatterns.isNestedField(field))
    });
  }
  render() {
    if (!this.state.indexPattern) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h6", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.source.esGeoLine.metricsLabel",
      defaultMessage: "Track metrics",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_metrics_editor.MetricsEditor, {
      allowMultipleMetrics: true,
      bucketsName: this.props.bucketsName,
      isJoin: false,
      fields: this.state.fields,
      metrics: this.props.metrics,
      onChange: this._onMetricsChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h6", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.source.esGeoLine.trackSettingsLabel",
      defaultMessage: "Tracks",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_geo_line_form.GeoLineForm, {
      isColumnCompressed: true,
      indexPattern: this.state.indexPattern,
      onGroupByTimeseriesChange: this._onGroupByTimeseriesChange,
      onLineSimplificationSizeChange: this._onLineSimplificationSizeChange,
      onSortFieldChange: this._onSortFieldChange,
      onSplitFieldChange: this._onSplitFieldChange,
      groupByTimeseries: this.props.groupByTimeseries,
      lineSimplificationSize: this.props.lineSimplificationSize,
      sortField: this.props.sortField,
      splitField: this.props.splitField,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 9
      }
    }));
  }
}
exports.UpdateSourceEditor = UpdateSourceEditor;