"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolbarPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _chartIcons = require("@kbn/chart-icons");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/shared_components/toolbar_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const typeToIconMap = {
  legend: _chartIcons.EuiIconLegend,
  values: 'number',
  list: 'list',
  visualOptions: 'brush',
  titlesAndText: 'visText'
};
const defaultPanelStyles = {
  width: '420px'
};
const ToolbarPopover = ({
  children,
  title,
  type,
  isDisabled = false,
  groupPosition,
  buttonDataTestSubj,
  handleClose,
  panelStyle = defaultPanelStyles,
  ...euiPopoverProps
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const iconType = typeof type === 'string' ? typeToIconMap[type] : type;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, (0, _extends2.default)({
    panelStyle: panelStyle,
    ownFocus: true,
    "aria-label": title,
    button: /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.ToolbarButton, {
      as: 'iconButton',
      iconType: iconType,
      onClick: () => {
        setIsOpen(!isOpen);
      },
      label: title,
      "aria-label": title,
      isDisabled: isDisabled,
      groupPosition: groupPosition,
      "data-test-subj": buttonDataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 11
      }
    }),
    isOpen: isOpen,
    closePopover: () => {
      setIsOpen(false);
      handleClose === null || handleClose === void 0 ? void 0 : handleClose();
    },
    anchorPosition: "downRight",
    panelPaddingSize: "m"
  }, euiPopoverProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    "data-test-subj": `${euiPopoverProps['data-test-subj']}_title`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, title), children));
};
exports.ToolbarPopover = ToolbarPopover;