"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingWithSiblingFlyout = SettingWithSiblingFlyout;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _flyout = require("./flyout.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/shared_components/setting_with_sibling_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_TITLE = _i18n.i18n.translate('xpack.lens.colorSiblingFlyoutTitle', {
  defaultMessage: 'Color'
});
function SettingWithSiblingFlyout({
  siblingRef,
  children,
  title = DEFAULT_TITLE,
  isInlineEditing,
  SettingTrigger,
  dataTestSubj = 'lns-settingWithSiblingFlyout'
}) {
  const [focusTrapIsEnabled, setFocusTrapIsEnabled] = (0, _react.useState)(false);
  const [isFlyoutOpen, setIsFlyoutOpen] = (0, _react.useState)(false);
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const toggleFlyout = () => {
    setIsFlyoutOpen(!isFlyoutOpen);
  };
  const closeFlyout = () => {
    setIsFlyoutOpen(false);
    setFocusTrapIsEnabled(false);
  };
  (0, _react.useEffect)(() => {
    // The EuiFocusTrap is disabled when inline editing as it causes bugs with comboboxes
    if (isFlyoutOpen && !isInlineEditing) {
      // without setTimeout here the flyout pushes content when animating
      setTimeout(() => {
        setFocusTrapIsEnabled(true);
      }, 255);
    }
  }, [isInlineEditing, isFlyoutOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(SettingTrigger, {
    onClick: toggleFlyout,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }), isFlyoutOpen && siblingRef.current && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    insert: {
      sibling: siblingRef.current,
      position: 'after'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    disabled: !focusTrapIsEnabled,
    clickOutsideDisables: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: closeFlyout,
    isDisabled: !isFlyoutOpen,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    role: "dialog",
    "aria-labelledby": "lnsSettingWithSiblingFlyoutTitle",
    "data-test-subj": dataTestSubj,
    css: [(0, _flyout.flyoutContainerStyles)(euiThemeContext), siblingflyoutContainerStyles.self(euiThemeContext)],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    css: siblingflyoutContainerStyles.header(euiThemeContext),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    "data-test-subj": "lns-indexPattern-SettingWithSiblingFlyoutBack",
    className: "lnsSettingWithSiblingFlyout__backIcon",
    onClick: closeFlyout,
    iconType: "sortLeft",
    "aria-label": _i18n.i18n.translate('xpack.lens.settingWithSiblingFlyout.back', {
      defaultMessage: 'Back'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "lnsSettingWithSiblingFlyoutTitle",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 25
    }
  }, title))))), children && /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-yScroll",
    css: (0, _react2.css)`
                      flex: 1;
                    `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 19
    }
  }, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    css: siblingflyoutContainerStyles.footer(euiThemeContext),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "s",
    iconType: "sortLeft",
    onClick: closeFlyout,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.lens.settingWithSiblingFlyout.back', {
    defaultMessage: 'Back'
  }))))))));
}
const siblingflyoutContainerStyles = {
  self: ({
    euiTheme
  }) => (0, _react2.css)`
    position: absolute;
    right: 0;
    left: 0;
    top: 0;
    bottom: 0;
    // making just a bit higher than the dimension flyout to stack on top of it
    z-index: ${euiTheme.levels.menu};
  `,
  header: ({
    euiTheme
  }) => (0, _react2.css)`
    padding: ${euiTheme.size.base};
  `,
  footer: ({
    euiTheme
  }) => (0, _react2.css)`
    padding: ${euiTheme.size.base};
  `
};