"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEIGHTS = exports.ToolbarButton = exports.TOOLBAR_BUTTON_SIZES = exports.POSITIONS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/shared_components/dataview_picker/toolbar_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const groupPositionToClassMap = {
  none: null,
  left: 'kbnToolbarButton--groupLeft',
  center: 'kbnToolbarButton--groupCenter',
  right: 'kbnToolbarButton--groupRight'
};
const POSITIONS = exports.POSITIONS = Object.keys(groupPositionToClassMap);
const WEIGHTS = exports.WEIGHTS = ['normal', 'bold'];
const TOOLBAR_BUTTON_SIZES = exports.TOOLBAR_BUTTON_SIZES = ['s', 'm'];
const ToolbarButton = ({
  children,
  className,
  fontWeight = 'normal',
  size = 'm',
  hasArrow = true,
  groupPosition = 'none',
  dataTestSubj = '',
  textProps,
  ...rest
}) => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const classes = (0, _classnames.default)('kbnToolbarButton', groupPositionToClassMap[groupPosition], [`kbnToolbarButton--${fontWeight}`, `kbnToolbarButton--${size}`], className);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "data-test-subj": dataTestSubj,
    className: classes,
    iconSide: "right",
    css: toolbarButtonStyles(euiThemeContext),
    iconType: hasArrow ? 'arrowDown' : '',
    color: "text",
    contentProps: {
      className: 'kbnToolbarButton__content'
    },
    textProps: {
      ...textProps,
      className: (0, _classnames.default)('kbnToolbarButton__text', textProps && textProps.className)
    }
  }, rest, {
    size: size,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }), children);
};
exports.ToolbarButton = ToolbarButton;
const toolbarButtonStyles = euiThemeContext => {
  const {
    euiTheme
  } = euiThemeContext;
  return (0, _react2.css)`
    &.kbnToolbarButton {
      line-height: ${euiTheme.size.xxl}; // Keeps alignment of text and chart icon

      // todo: once issue https://github.com/elastic/eui/issues/4730 is merged, this code might be safe to remove
      // Some toolbar buttons are just icons, but EuiButton comes with margin and min-width that need to be removed
      min-width: 0;
      border-width: ${euiTheme.border.width.thin};
      border-style: solid;
      border-color: ${euiTheme.colors.borderBasePlain}; // Lighten the border color for all states

      // Override background color for non-disabled buttons
      &:not(:disabled) {
        background-color: ${euiTheme.colors.backgroundBasePlain};
      }

      &.kbnToolbarButton__text > svg {
        margin-top: -1px; // Just some weird alignment issue when icon is the child not the iconType
      }

      &.kbnToolbarButton__text:empty {
        margin: 0;
      }

      // Toolbar buttons don't look good with centered text when fullWidth
      &[class*='fullWidth'] {
        text-align: left;

        .kbnToolbarButton__content {
          justify-content: space-between;
        }
      }
    }

    &.kbnToolbarButton--groupLeft {
      border-top-right-radius: 0;
      border-bottom-right-radius: 0;
    }

    &.kbnToolbarButton--groupCenter {
      border-radius: 0;
      border-left: none;
    }

    &.kbnToolbarButton--groupRight {
      border-top-left-radius: 0;
      border-bottom-left-radius: 0;
      border-left: none;
    }

    &.kbnToolbarButton--bold {
      font-weight: ${euiTheme.font.weight.bold};
    }

    &.kbnToolbarButton--normal {
      font-weight: ${euiTheme.font.weight.regular};
    }

    &.kbnToolbarButton--s {
      box-shadow: none !important; // sass-lint:disable-line no-important
      font-size: ${(0, _eui.euiFontSize)(euiThemeContext, 's').fontSize};
    }
  `;
};