"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensRenderer = LensRenderer;
var _public = require("@kbn/embeddable-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _constants = require("../../../common/constants");
var _helper = require("../helper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/react_embeddable/renderer/lens_custom_renderer_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// This little utility uses the same pattern of the useSearchApi hook:
// create the Subject once and then update its value on change
function useObservableVariable(value) {
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const observable = (0, _react.useMemo)(() => new _rxjs.BehaviorSubject(value), []);

  // update the observable on change
  (0, _react.useEffect)(() => {
    observable.next(value);
  }, [observable, value]);
  return observable;
}
/**
 * The aim of this component is to provide a wrapper for other plugins who want to
 * use a Lens component into their own page. This hides the embeddable parts of it
 * by wrapping it into a ReactEmbeddableRenderer component and exposing a custom API
 */
function LensRenderer({
  title,
  withDefaultActions,
  extraActions,
  showInspector,
  syncColors,
  syncCursor,
  syncTooltips,
  viewMode,
  id,
  query,
  filters,
  timeRange,
  disabledActions,
  searchSessionId,
  forceDSL,
  hidePanelTitles,
  lastReloadRequestTime,
  ...props
}) {
  // Use the settings interface to store panel settings
  const settings = (0, _react.useMemo)(() => {
    return {
      syncColors$: new _rxjs.BehaviorSubject(false),
      syncCursor$: new _rxjs.BehaviorSubject(false),
      syncTooltips$: new _rxjs.BehaviorSubject(false)
    };
  }, []);
  const disabledActionIds$ = useObservableVariable(disabledActions);
  const viewMode$ = useObservableVariable(viewMode);
  const searchSessionId$ = useObservableVariable(searchSessionId);
  const hideTitle$ = useObservableVariable(hidePanelTitles);
  const esqlVariables$ = useObservableVariable(props.esqlVariables);

  // Lens API will be set once, but when set trigger a reflow to adopt the latest attributes
  const [lensApi, setLensApi] = (0, _react.useState)(undefined);
  const initialStateRef = (0, _react.useRef)(props.attributes ? {
    attributes: props.attributes
  } : (0, _helper.createEmptyLensState)(null, title));
  const searchApi = (0, _presentationPublishing.useSearchApi)({
    query,
    filters,
    timeRange
  });
  const showPanelChrome = Boolean(withDefaultActions) || ((extraActions === null || extraActions === void 0 ? void 0 : extraActions.length) || 0) > 0;
  const reload$ = (0, _react.useMemo)(() => new _rxjs.BehaviorSubject(undefined), []);
  (0, _react.useEffect)(() => {
    reload$.next();
  }, [reload$, lastReloadRequestTime]);

  // Re-render on changes
  // internally the embeddable will evaluate whether it is worth to actual render or not
  (0, _react.useEffect)(() => {
    // trigger a re-render if the attributes change
    if (lensApi) {
      lensApi.updateAttributes({
        ...('attributes' in initialStateRef.current ? initialStateRef.current.attributes : initialStateRef.current),
        ...props.attributes
      });
      lensApi.updateOverrides(props.overrides);
    }
  }, [lensApi, props.attributes, props.overrides]);
  (0, _react.useEffect)(() => {
    if (syncColors != null && settings.syncColors$.getValue() !== syncColors) {
      settings.syncColors$.next(syncColors);
    }
    if (syncCursor != null && settings.syncCursor$.getValue() !== syncCursor) {
      settings.syncCursor$.next(syncCursor);
    }
    if (syncTooltips != null && settings.syncTooltips$.getValue() !== syncTooltips) {
      settings.syncTooltips$.next(syncTooltips);
    }
  }, [settings, syncColors, syncCursor, syncTooltips]);
  const panelProps = (0, _react.useMemo)(() => {
    return {
      hideInspector: !showInspector,
      showNotifications: false,
      showShadow: false,
      showBadges: false,
      getActions: async (triggerId, context) => {
        const actions = withDefaultActions ? await (lensApi === null || lensApi === void 0 ? void 0 : lensApi.getTriggerCompatibleActions(triggerId, context)) : [];
        return (extraActions !== null && extraActions !== void 0 ? extraActions : []).concat(actions || []);
      }
    };
  }, [showInspector, withDefaultActions, extraActions, lensApi]);
  return /*#__PURE__*/_react.default.createElement(_public.EmbeddableRenderer, {
    type: _constants.LENS_EMBEDDABLE_TYPE,
    maybeId: id
    // TODO type this ParentApi, all these are untyped and some unused
    ,
    getParentApi: () => ({
      // forward the Lens components to the embeddable
      ...props,
      // forward the unified search context
      ...searchApi,
      searchSessionId$,
      disabledActionIds$,
      setDisabledActionIds: ids => disabledActionIds$.next(ids),
      viewMode$,
      // pass the sync* settings with the unified settings interface
      settings,
      // make sure to provide the initial state (useful for the comparison check)
      getSerializedStateForChild: () => ({
        rawState: initialStateRef.current,
        references: []
      }),
      // update the runtime state on changes
      getRuntimeStateForChild: () => ({
        ...initialStateRef.current,
        attributes: props.attributes
      }),
      forceDSL,
      esqlVariables$,
      hideTitle$,
      reload$ // trigger a reload (replacement for deprepcated searchSessionId)
    }),
    onApiAvailable: setLensApi,
    hidePanelChrome: !showPanelChrome,
    panelProps: panelProps,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 5
    }
  });
}