"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerSettingsPanel = LayerSettingsPanel;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _randomSampling = require("@kbn/random-sampling");
var _utils = require("./utils");
var _ignore_global_filter = require("../../shared_components/ignore_global_filter");
var _lens_ui_telemetry = require("../../lens_ui_telemetry");
var _shared_components = require("../../shared_components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/layer_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const samplingValues = [{
  label: '.001%',
  value: 0.00001,
  accessibleLabel: _i18n.i18n.translate('xpack.lens.randomSampling.ui.sliderControl.tickLabels.0.00001', {
    defaultMessage: 'Point zero zero one percent, most performant'
  })
}, {
  label: '.01%',
  value: 0.0001
}, {
  label: '.1%',
  value: 0.001
}, {
  label: '1%',
  value: 0.01
}, {
  label: '10%',
  value: 0.1
}, {
  label: '100%',
  value: 1,
  accessibleLabel: _i18n.i18n.translate('xpack.lens.randomSampling.ui.sliderControl.tickLabels.1', {
    defaultMessage: 'One hundred percent, most accurate'
  })
}];
function LayerSettingsPanel({
  state,
  setState,
  layerId
}) {
  const isSamplingValueDisabled = !(0, _utils.isSamplingValueEnabled)(state.layers[layerId]);
  const currentValue = isSamplingValueDisabled ? samplingValues[samplingValues.length - 1].value : state.layers[layerId].sampling;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    "data-test-subj": "lns-indexPattern-random-sampling-row",
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.indexPattern.randomSampling.help",
      defaultMessage: "Lower sampling percentages increases the performance, but lowers the accuracy. Lower sampling percentages are best for large datasets. {link}",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: "https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-random-sampler-aggregation.html",
          target: "_blank",
          external: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 81,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.lens.indexPattern.randomSampling.learnMore",
          defaultMessage: "View documentation",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 86,
            columnNumber: 23
          }
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 15
      }
    }))),
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.lens.indexPattern.randomSampling.label', {
      defaultMessage: 'Sampling'
    }), ' ', /*#__PURE__*/_react.default.createElement(_shared_components.ExperimentalBadge, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 13
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_randomSampling.RandomSamplingSlider, {
    disabled: isSamplingValueDisabled,
    disabledReason: _i18n.i18n.translate('xpack.lens.indexPattern.randomSampling.disabledMessage', {
      defaultMessage: 'In order to select a reduced sampling percentage, you must remove any maximum or minimum functions applied on this layer.'
    }),
    values: samplingValues,
    currentValue: currentValue,
    "data-test-subj": "lns-indexPattern-random-sampling-slider",
    onChange: newSamplingValue => {
      if (newSamplingValue < 1) {
        (0, _lens_ui_telemetry.trackUiCounterEvents)('apply_random_sampling');
      }
      setState({
        ...state,
        layers: {
          ...state.layers,
          [layerId]: {
            ...state.layers[layerId],
            sampling: newSamplingValue
          }
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_ignore_global_filter.IgnoreGlobalFilterRowControl, {
    checked: !state.layers[layerId].ignoreGlobalFilters,
    onChange: () => {
      const newLayer = {
        ...state.layers[layerId],
        ignoreGlobalFilters: !state.layers[layerId].ignoreGlobalFilters
      };
      const newLayers = {
        ...state.layers
      };
      newLayers[layerId] = newLayer;
      (0, _lens_ui_telemetry.trackUiCounterEvents)(newLayer.ignoreGlobalFilters ? `ignore_global_filters` : `use_global_filters`);
      setState({
        ...state,
        layers: newLayers
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }));
}