"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTextBasedDatasource = getTextBasedDatasource;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _esqlUtils = require("@kbn/esql-utils");
var _esQuery = require("@kbn/es-query");
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _lodash = require("lodash");
var _datapanel = require("./components/datapanel");
var _dimension_editor = require("./components/dimension_editor");
var _dimension_trigger = require("./components/dimension_trigger");
var _to_expression = require("./to_expression");
var _id_generator = require("../../../id_generator");
var _utils = require("../../../utils");
var _dnd = require("./dnd");
var _remove_column = require("./remove_column");
var _utils2 = require("./utils");
var _fieldlist_cache = require("./fieldlist_cache");
var _user_messages_ids = require("../../../user_messages_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/esql_layer/text_based_languages.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getLayerReferenceName(layerId) {
  return `textBasedLanguages-datasource-layer-${layerId}`;
}
const getSelectedFieldsFromColumns = (0, _memoizeOne.default)(columns => columns.map(c => {
  if ('fieldName' in c) {
    return c.fieldName;
  }
}).filter(_utils.nonNullable), _lodash.isEqual);
const getUnchangedSuggestionTable = (state, allColumns, id) => {
  var _state$layers$id$colu, _state$layers$id$colu2;
  return {
    state: {
      ...state
    },
    table: {
      changeType: 'unchanged',
      isMultiRow: false,
      layerId: id,
      columns: (_state$layers$id$colu = (_state$layers$id$colu2 = state.layers[id].columns) === null || _state$layers$id$colu2 === void 0 ? void 0 : _state$layers$id$colu2.map(f => {
        var _f$meta, _f$meta2;
        const inMetricDimension = (0, _utils2.canColumnBeUsedBeInMetricDimension)(allColumns, f === null || f === void 0 ? void 0 : (_f$meta = f.meta) === null || _f$meta === void 0 ? void 0 : _f$meta.type);
        return {
          columnId: f.columnId,
          operation: {
            dataType: f === null || f === void 0 ? void 0 : (_f$meta2 = f.meta) === null || _f$meta2 === void 0 ? void 0 : _f$meta2.type,
            label: f.fieldName,
            isBucketed: Boolean((0, _utils2.isNotNumeric)(f)),
            // makes non-number fields to act as metrics, used for datatable suggestions
            ...(inMetricDimension && {
              inMetricDimension
            })
          }
        };
      })) !== null && _state$layers$id$colu !== void 0 ? _state$layers$id$colu : []
    },
    keptLayerIds: [id]
  };
};
const getSuggestionsByRules = (state, allColumns, id, rules) => {
  var _columnsToKeep$map;
  const columnsToKeep = rules.reduce((acc, rule) => {
    var _state$layers$id$colu3;
    const fn = rule.isBucketed ? _utils2.isNotNumeric : _utils2.isNumeric;
    let column = (_state$layers$id$colu3 = state.layers[id].columns) === null || _state$layers$id$colu3 === void 0 ? void 0 : _state$layers$id$colu3.find(col => fn(col) && !acc.some(c => c.columnId === col.columnId));
    if (!column && rule.allowAll) {
      var _state$layers$id$colu4;
      column = (_state$layers$id$colu4 = state.layers[id].columns) === null || _state$layers$id$colu4 === void 0 ? void 0 : _state$layers$id$colu4.find(col => !acc.some(c => c.columnId === col.columnId));
    }
    return column ? [...acc, column] : acc;
  }, []);
  if (!columnsToKeep.length || columnsToKeep.length !== rules.length) {
    return;
  }
  return {
    state: {
      ...state,
      layers: {
        [id]: {
          ...state.layers[id],
          columns: columnsToKeep
        }
      }
    },
    table: {
      changeType: 'reduced',
      isMultiRow: false,
      layerId: id,
      columns: (_columnsToKeep$map = columnsToKeep === null || columnsToKeep === void 0 ? void 0 : columnsToKeep.map((f, i) => {
        var _f$meta3, _f$meta4;
        const inMetricDimension = (0, _utils2.canColumnBeUsedBeInMetricDimension)(allColumns, f === null || f === void 0 ? void 0 : (_f$meta3 = f.meta) === null || _f$meta3 === void 0 ? void 0 : _f$meta3.type);
        return {
          columnId: f.columnId,
          operation: {
            dataType: f === null || f === void 0 ? void 0 : (_f$meta4 = f.meta) === null || _f$meta4 === void 0 ? void 0 : _f$meta4.type,
            label: f.fieldName,
            isBucketed: !!rules[i].isBucketed,
            // makes non-number fields to act as metrics, used for datatable suggestions
            ...(inMetricDimension && {
              inMetricDimension
            })
          }
        };
      })) !== null && _columnsToKeep$map !== void 0 ? _columnsToKeep$map : []
    },
    keptLayerIds: [id]
  };
};
function getTextBasedDatasource({
  core,
  storage,
  data,
  expressions,
  dataViews
}) {
  const getSuggestionsForState = state => {
    var _Object$entries;
    return (_Object$entries = Object.entries(state.layers)) === null || _Object$entries === void 0 ? void 0 : _Object$entries.flatMap(([id, layer]) => {
      const allColumns = (0, _fieldlist_cache.retrieveLayerColumnsFromCache)(layer.columns, layer.query);
      if (!allColumns.length && layer.query) {
        const layerColumns = layer.columns.map(c => ({
          id: c.columnId,
          name: c.fieldName,
          meta: c.meta
        }));
        (0, _fieldlist_cache.addColumnsToCache)(layer.query, layerColumns);
      }
      const unchangedSuggestionTable = getUnchangedSuggestionTable(state, allColumns, id);

      // we are trying here to cover the most common cases for the charts we offer
      const metricTable = getSuggestionsByRules(state, allColumns, id, [{
        isBucketed: false
      }]);
      const metricBucketTable = getSuggestionsByRules(state, allColumns, id, [{
        isBucketed: false
      }, {
        isBucketed: true,
        allowAll: true
      }]);
      const metricBucketBucketTable = getSuggestionsByRules(state, allColumns, id, [{
        isBucketed: false
      }, {
        isBucketed: true,
        allowAll: true
      }, {
        isBucketed: true,
        allowAll: true
      }]);
      return [unchangedSuggestionTable, metricBucketBucketTable, metricBucketTable, metricTable].filter(_utils.nonNullable).reduce((acc, cur) => {
        if (acc.find(({
          table
        }) => (0, _lodash.isEqual)(table.columns, cur.table.columns))) {
          return acc;
        }
        return [...acc, cur];
      }, []);
    });
  };
  const getSuggestionsForVisualizeField = (state, indexPatternId, fieldName) => {
    const context = state.initialContext;
    // on text based mode we offer suggestions for the query and not for a specific field
    if (fieldName) return [];
    if (context && 'dataViewSpec' in context && context.dataViewSpec.title && context.query) {
      var _context$textBasedCol, _context$textBasedCol2, _context$dataViewSpec, _newColumns$map;
      const newLayerId = (0, _id_generator.generateId)();
      const textBasedQueryColumns = (_context$textBasedCol = (_context$textBasedCol2 = context.textBasedColumns) === null || _context$textBasedCol2 === void 0 ? void 0 : _context$textBasedCol2.slice(0, _utils2.MAX_NUM_OF_COLUMNS)) !== null && _context$textBasedCol !== void 0 ? _context$textBasedCol : [];
      // Number fields are assigned automatically as metrics (!isBucketed). There are cases where the query
      // will not return number fields. In these cases we want to suggest a datatable
      // Datatable works differently in this case. On the metrics dimension can be all type of fields
      const hasNumberTypeColumns = textBasedQueryColumns === null || textBasedQueryColumns === void 0 ? void 0 : textBasedQueryColumns.some(_utils2.isNumeric);
      const newColumns = textBasedQueryColumns.map(c => {
        var _c$meta, _c$variable;
        const inMetricDimension = (0, _utils2.canColumnBeUsedBeInMetricDimension)(textBasedQueryColumns, c === null || c === void 0 ? void 0 : (_c$meta = c.meta) === null || _c$meta === void 0 ? void 0 : _c$meta.type);
        return {
          columnId: (_c$variable = c.variable) !== null && _c$variable !== void 0 ? _c$variable : c.id,
          fieldName: c.variable ? `??${c.variable}` : c.id,
          variable: c.variable,
          label: c.name,
          customLabel: c.id !== c.name,
          meta: c.meta,
          // makes non-number fields to act as metrics, used for datatable suggestions
          ...(inMetricDimension && {
            inMetricDimension
          })
        };
      });
      (0, _fieldlist_cache.addColumnsToCache)(context.query, textBasedQueryColumns);
      const index = (_context$dataViewSpec = context.dataViewSpec.id) !== null && _context$dataViewSpec !== void 0 ? _context$dataViewSpec : context.dataViewSpec.title;
      const query = context.query;
      const updatedState = {
        ...state,
        initialContext: undefined,
        ...(context.dataViewSpec.id ? {
          indexPatternRefs: [{
            id: context.dataViewSpec.id,
            title: context.dataViewSpec.title,
            timeField: context.dataViewSpec.timeFieldName
          }]
        } : {}),
        layers: {
          ...state.layers,
          [newLayerId]: {
            index,
            query,
            columns: newColumns !== null && newColumns !== void 0 ? newColumns : [],
            timeField: context.dataViewSpec.timeFieldName
          }
        }
      };
      return [{
        state: {
          ...updatedState
        },
        table: {
          changeType: 'initial',
          isMultiRow: false,
          notAssignedMetrics: !hasNumberTypeColumns,
          layerId: newLayerId,
          columns: (_newColumns$map = newColumns === null || newColumns === void 0 ? void 0 : newColumns.map(f => {
            var _f$meta5;
            return {
              columnId: f.columnId,
              operation: {
                dataType: f === null || f === void 0 ? void 0 : (_f$meta5 = f.meta) === null || _f$meta5 === void 0 ? void 0 : _f$meta5.type,
                label: f.fieldName,
                isBucketed: Boolean((0, _utils2.isNotNumeric)(f))
              }
            };
          })) !== null && _newColumns$map !== void 0 ? _newColumns$map : []
        },
        keptLayerIds: [newLayerId]
      }];
    }
    return [];
  };
  const TextBasedDatasource = {
    id: 'textBased',
    checkIntegrity: () => {
      return [];
    },
    getUserMessages: state => {
      const errors = [];
      Object.values(state.layers).forEach(layer => {
        if (layer.errors && layer.errors.length > 0) {
          errors.push(...layer.errors);
        }
      });
      return errors.map(err => {
        const message = {
          uniqueId: _user_messages_ids.TEXT_BASED_LANGUAGE_ERROR,
          severity: 'error',
          fixableInEditor: true,
          displayLocations: [{
            id: 'visualization'
          }, {
            id: 'textBasedLanguagesQueryInput'
          }],
          shortMessage: err.message,
          longMessage: err.message
        };
        return message;
      });
    },
    initialize(state, references, context, indexPatternRefs, indexPatterns) {
      const patterns = indexPatterns ? Object.values(indexPatterns) : [];
      const refs = patterns.map(p => {
        return {
          id: p.id,
          title: p.title,
          timeField: p.timeFieldName
        };
      });
      const initState = state || {
        layers: {}
      };
      return {
        ...initState,
        indexPatternRefs: refs,
        initialContext: context
      };
    },
    syncColumns({
      state
    }) {
      // TODO implement this for real
      return state;
    },
    onRefreshIndexPattern() {},
    getUsedDataViews: state => {
      return Object.values(state.layers).map(({
        index
      }) => index).filter(_utils.nonNullable);
    },
    getPersistableState({
      layers
    }) {
      const references = [];
      Object.entries(layers).forEach(([layerId, {
        index,
        ...persistableLayer
      }]) => {
        if (index) {
          references.push({
            type: 'index-pattern',
            id: index,
            name: getLayerReferenceName(layerId)
          });
        }
      });
      return {
        state: {
          layers
        },
        references
      };
    },
    insertLayer(state, newLayerId) {
      var _Object$values, _layer$index;
      const layer = (_Object$values = Object.values(state === null || state === void 0 ? void 0 : state.layers)) === null || _Object$values === void 0 ? void 0 : _Object$values[0];
      const query = layer === null || layer === void 0 ? void 0 : layer.query;
      const index = (_layer$index = layer === null || layer === void 0 ? void 0 : layer.index) !== null && _layer$index !== void 0 ? _layer$index : JSON.parse(localStorage.getItem('lens-settings') || '{}').indexPatternId || state.indexPatternRefs[0].id;
      return {
        ...state,
        layers: {
          ...state.layers,
          [newLayerId]: blankLayer(index, query)
        }
      };
    },
    createEmptyLayer() {
      return {
        indexPatternRefs: [],
        layers: {}
      };
    },
    cloneLayer(state, layerId, newLayerId, getNewId) {
      return {
        ...state
      };
    },
    removeLayer(state, layerId) {
      const newLayers = {
        ...state.layers,
        [layerId]: {
          ...state.layers[layerId],
          columns: []
        }
      };
      return {
        removedLayerIds: [layerId],
        newState: {
          ...state,
          layers: newLayers
        }
      };
    },
    clearLayer(state, layerId) {
      return {
        removedLayerIds: [],
        newState: {
          ...state,
          layers: {
            ...state.layers,
            [layerId]: {
              ...state.layers[layerId],
              columns: []
            }
          }
        }
      };
    },
    getLayers(state) {
      return state && state.layers ? Object.keys(state === null || state === void 0 ? void 0 : state.layers) : [];
    },
    isTimeBased: (state, indexPatterns) => {
      if (!state) return false;
      const {
        layers
      } = state;
      return Boolean(layers) && Object.values(layers).some(layer => {
        var _indexPatterns$layer$;
        return layer.index && Boolean((_indexPatterns$layer$ = indexPatterns[layer.index]) === null || _indexPatterns$layer$ === void 0 ? void 0 : _indexPatterns$layer$.timeFieldName);
      });
    },
    getUsedDataView: (state, layerId) => {
      if (!layerId || !state.layers[layerId].index) {
        var _layers$;
        const layers = Object.values(state.layers);
        return layers === null || layers === void 0 ? void 0 : (_layers$ = layers[0]) === null || _layers$ === void 0 ? void 0 : _layers$.index;
      }
      return state.layers[layerId].index;
    },
    removeColumn: _remove_column.removeColumn,
    toExpression: (state, layerId, indexPatterns, dateRange, searchSessionId) => {
      return (0, _to_expression.toExpression)(state, layerId);
    },
    getSelectedFields(state) {
      var _Object$values2;
      return getSelectedFieldsFromColumns((_Object$values2 = Object.values(state === null || state === void 0 ? void 0 : state.layers)) === null || _Object$values2 === void 0 ? void 0 : _Object$values2.flatMap(l => Object.values(l.columns)));
    },
    DataPanelComponent(props) {
      var _TextBasedDatasource$;
      const layerFields = TextBasedDatasource === null || TextBasedDatasource === void 0 ? void 0 : (_TextBasedDatasource$ = TextBasedDatasource.getSelectedFields) === null || _TextBasedDatasource$ === void 0 ? void 0 : _TextBasedDatasource$.call(TextBasedDatasource, props.state);
      return /*#__PURE__*/_react.default.createElement(_datapanel.TextBasedDataPanel, (0, _extends2.default)({
        data: data,
        dataViews: dataViews,
        expressions: expressions,
        layerFields: layerFields
      }, props, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 480,
          columnNumber: 9
        }
      }));
    },
    DimensionTriggerComponent: props => {
      const columnLabelMap = TextBasedDatasource.uniqueLabels(props.state, props.indexPatterns);
      return /*#__PURE__*/_react.default.createElement(_dimension_trigger.TextBasedDimensionTrigger, (0, _extends2.default)({}, props, {
        expressions: expressions,
        columnLabelMap: columnLabelMap,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 493,
          columnNumber: 9
        }
      }));
    },
    getRenderEventCounters(state) {
      const context = state === null || state === void 0 ? void 0 : state.initialContext;
      if (context && 'query' in context && context.query && (0, _esQuery.isOfAggregateQueryType)(context.query)) {
        const language = (0, _esQuery.getAggregateQueryMode)(context.query);
        // it will eventually log render_lens_esql_chart
        return [`${language}_chart`];
      }
      return [];
    },
    DimensionEditorComponent: props => {
      return /*#__PURE__*/_react.default.createElement(_dimension_editor.TextBasedDimensionEditor, (0, _extends2.default)({}, props, {
        expressions: expressions,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 512,
          columnNumber: 14
        }
      }));
    },
    LayerPanelComponent: props => {
      return null;
    },
    uniqueLabels(state) {
      const layers = state.layers;
      const columnLabelMap = {};
      const uniqueLabelGenerator = (0, _utils.getUniqueLabelGenerator)();
      Object.values(layers).forEach(layer => {
        if (!layer.columns) {
          return;
        }
        Object.values(layer.columns).forEach(column => {
          columnLabelMap[column.columnId] = uniqueLabelGenerator(column.fieldName);
        });
      });
      return columnLabelMap;
    },
    getDropProps: _dnd.getDropProps,
    onDrop: _dnd.onDrop,
    getPublicAPI({
      state,
      layerId,
      indexPatterns
    }) {
      return {
        datasourceId: 'textBased',
        getTableSpec: () => {
          var _state$layers$layerId;
          return ((_state$layers$layerId = state.layers[layerId]) === null || _state$layers$layerId === void 0 ? void 0 : _state$layers$layerId.columns.map(column => ({
            columnId: column.columnId,
            fields: [column.fieldName]
          }))) || [];
        },
        getOperationForColumnId: columnId => {
          var _layer$columns, _column$meta;
          const layer = state.layers[layerId];
          const column = layer === null || layer === void 0 ? void 0 : (_layer$columns = layer.columns) === null || _layer$columns === void 0 ? void 0 : _layer$columns.find(c => c.columnId === columnId);
          const columnLabelMap = TextBasedDatasource.uniqueLabels(state, indexPatterns);
          let scale = 'ordinal';
          switch (column === null || column === void 0 ? void 0 : (_column$meta = column.meta) === null || _column$meta === void 0 ? void 0 : _column$meta.type) {
            case 'date':
              scale = 'interval';
              break;
            case 'number':
              scale = 'ratio';
              break;
            default:
              scale = 'ordinal';
              break;
          }
          if (column) {
            var _column$meta2, _columnLabelMap$colum;
            return {
              dataType: column === null || column === void 0 ? void 0 : (_column$meta2 = column.meta) === null || _column$meta2 === void 0 ? void 0 : _column$meta2.type,
              label: (_columnLabelMap$colum = columnLabelMap[columnId]) !== null && _columnLabelMap$colum !== void 0 ? _columnLabelMap$colum : column === null || column === void 0 ? void 0 : column.fieldName,
              isBucketed: Boolean((0, _utils2.isNotNumeric)(column)),
              inMetricDimension: column.inMetricDimension,
              hasTimeShift: false,
              hasReducedTimeRange: false,
              scale
            };
          }
          return null;
        },
        getVisualDefaults: () => ({}),
        isTextBasedLanguage: () => true,
        getMaxPossibleNumValues: columnId => {
          return null;
        },
        getSourceId: () => {
          const layer = state.layers[layerId];
          return layer.index;
        },
        getFilters: () => {
          return {
            enabled: {
              kuery: [],
              lucene: []
            },
            disabled: {
              kuery: [],
              lucene: []
            }
          };
        },
        hasDefaultTimeField: () => false
      };
    },
    getDatasourceSuggestionsForField(state, draggedField) {
      var _layers$2, _Object$entries2;
      const layers = Object.values(state.layers);
      const query = layers === null || layers === void 0 ? void 0 : (_layers$2 = layers[0]) === null || _layers$2 === void 0 ? void 0 : _layers$2.query;
      const fieldList = query ? (0, _fieldlist_cache.getColumnsFromCache)(query) : [];
      const field = fieldList === null || fieldList === void 0 ? void 0 : fieldList.find(f => f.id === draggedField.id);
      if (!field) return [];
      return (_Object$entries2 = Object.entries(state.layers)) === null || _Object$entries2 === void 0 ? void 0 : _Object$entries2.map(([id, layer]) => {
        var _field$name, _layer$columns2, _field$meta, _field$name2;
        const newId = (0, _id_generator.generateId)();
        const newColumn = {
          columnId: newId,
          fieldName: (_field$name = field === null || field === void 0 ? void 0 : field.name) !== null && _field$name !== void 0 ? _field$name : '',
          meta: field === null || field === void 0 ? void 0 : field.meta
        };
        return {
          state: {
            ...state,
            layers: {
              ...state.layers,
              [id]: {
                ...state.layers[id],
                columns: [...layer.columns, newColumn]
              }
            }
          },
          table: {
            changeType: 'initial',
            isMultiRow: false,
            layerId: id,
            columns: [...((_layer$columns2 = layer.columns) === null || _layer$columns2 === void 0 ? void 0 : _layer$columns2.map(f => {
              var _f$meta6;
              return {
                columnId: f.columnId,
                operation: {
                  dataType: f === null || f === void 0 ? void 0 : (_f$meta6 = f.meta) === null || _f$meta6 === void 0 ? void 0 : _f$meta6.type,
                  label: f.fieldName,
                  isBucketed: Boolean((0, _utils2.isNotNumeric)(f))
                }
              };
            })), {
              columnId: newId,
              operation: {
                dataType: field === null || field === void 0 ? void 0 : (_field$meta = field.meta) === null || _field$meta === void 0 ? void 0 : _field$meta.type,
                label: (_field$name2 = field === null || field === void 0 ? void 0 : field.name) !== null && _field$name2 !== void 0 ? _field$name2 : '',
                isBucketed: Boolean((0, _utils2.isNotNumeric)(field))
              }
            }]
          },
          keptLayerIds: [id]
        };
      });
    },
    getDatasourceSuggestionsForVisualizeField: getSuggestionsForVisualizeField,
    getDatasourceSuggestionsFromCurrentState: getSuggestionsForState,
    getDatasourceSuggestionsForVisualizeCharts: getSuggestionsForState,
    isEqual: (persistableState1, references1, persistableState2, references2) =>
    // undefined is not equal to missing
    (0, _lodash.isEqual)({
      initialContext: undefined,
      ...persistableState1
    }, {
      initialContext: undefined,
      ...persistableState2
    }),
    getDatasourceInfo: async (state, references, dataViewsService) => {
      if (!dataViewsService) {
        return [];
      }
      const indexPatterns = [];
      for (const {
        query
      } of Object.values(state.layers)) {
        if (query) {
          const esqlAdhocDataview = await (0, _esqlUtils.getESQLAdHocDataview)(query.esql, dataViewsService);
          indexPatterns.push(esqlAdhocDataview);
        }
      }
      return Object.entries(state.layers).reduce((acc, [key, layer]) => {
        const columns = Object.entries(layer.columns).map(([colId, col]) => {
          var _col$meta, _col$meta2;
          return {
            id: colId,
            role: (0, _utils2.isNotNumeric)(col) ? 'split' : 'metric',
            operation: {
              dataType: col === null || col === void 0 ? void 0 : (_col$meta = col.meta) === null || _col$meta === void 0 ? void 0 : _col$meta.type,
              label: col.fieldName,
              isBucketed: Boolean((0, _utils2.isNotNumeric)(col)),
              hasTimeShift: false,
              hasReducedTimeRange: false,
              fields: [col.fieldName],
              type: ((_col$meta2 = col.meta) === null || _col$meta2 === void 0 ? void 0 : _col$meta2.type) || 'unknown',
              filter: undefined
            }
          };
        });
        acc.push({
          layerId: key,
          columns,
          dataView: indexPatterns === null || indexPatterns === void 0 ? void 0 : indexPatterns.find(dataView => dataView.id === layer.index)
        });
        return acc;
      }, []);
    }
  };
  return TextBasedDatasource;
}
function blankLayer(index, query) {
  return {
    index,
    query,
    columns: []
  };
}