"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toLocationObject = exports.reactRouterOnClickHandler = exports.reactRouterNavigate = void 0;
var _history = require("history");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isModifiedEvent = event => !!(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey);
const isLeftClickEvent = event => event.button === 0;
const toLocationObject = to => typeof to === 'string' ? (0, _history.parsePath)(to) : to;
exports.toLocationObject = toLocationObject;
const reactRouterNavigate = (history, to, onClickCallback) => ({
  href: history.createHref(toLocationObject(to)),
  onClick: reactRouterOnClickHandler(history, toLocationObject(to), onClickCallback)
});
exports.reactRouterNavigate = reactRouterNavigate;
const reactRouterOnClickHandler = (history, to, onClickCallback) => event => {
  var _event$target;
  if (onClickCallback) {
    onClickCallback(event);
  }
  if (event.defaultPrevented) {
    return;
  }
  if ((_event$target = event.target) !== null && _event$target !== void 0 && _event$target.getAttribute('target')) {
    return;
  }
  if (isModifiedEvent(event) || !isLeftClickEvent(event)) {
    return;
  }

  // prevents page reload
  event.preventDefault();
  history.push(toLocationObject(to));
};
exports.reactRouterOnClickHandler = reactRouterOnClickHandler;