"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddData = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _synopsis = require("../synopsis");
var _ui_metric = require("../../lib/ui_metric");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/kibana_overview/public/components/add_data/add_data.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const AddData = ({
  addBasePath,
  features
}) => {
  const {
    services: {
      application
    }
  } = (0, _public.useKibana)();
  return /*#__PURE__*/_react.default.createElement("section", {
    className: "kbnOverviewDataAdd",
    "aria-labelledby": "kbnOverviewDataAdd__title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "kbnOverviewDataAdd__title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "kibanaOverview.addData.sectionTitle",
    defaultMessage: "Ingest your data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "kbnOverviewDataAdd__actions",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    className: "kbnOverviewDataAdd__actionButton",
    flush: "both",
    href: addBasePath('#/tutorial_directory/sampleData'),
    iconType: "visTable",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "kibanaOverview.addData.sampleDataButtonLabel",
    defaultMessage: "Try our sample data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "kbnOverviewDataAdd__content",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, features.map(feature => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: feature.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_synopsis.Synopsis, {
    id: feature.id,
    description: feature.description,
    iconType: feature.icon,
    title: feature.title,
    url: addBasePath(feature.path),
    wrapInPanel: true,
    onClick: () => {
      (0, _ui_metric.trackUiMetric)(_ui_metric.METRIC_TYPE.CLICK, `ingest_data_card_${feature.id}`);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 15
    }
  }))))));
};
exports.AddData = AddData;
AddData.propTypes = {
  addBasePath: _propTypes.default.func.isRequired,
  features: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    title: _propTypes.default.string.isRequired,
    description: _propTypes.default.string.isRequired,
    icon: _propTypes.default.string.isRequired,
    path: _propTypes.default.string.isRequired,
    showOnHomePage: _propTypes.default.bool.isRequired,
    category: _propTypes.default.string.isRequired,
    order: _propTypes.default.number
  }).isRequired).isRequired
};