"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _control_editor = require("./control_editor");
var _editor_utils = require("../../editor_utils");
var _lineage = require("../../lineage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/input_control_vis/public/components/editor/controls_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ControlsTab extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      type: _editor_utils.CONTROL_TYPES.LIST
    });
    (0, _defineProperty2.default)(this, "getIndexPattern", async indexPatternId => {
      const [, startDeps] = await this.props.deps.core.getStartServices();
      return await startDeps.data.indexPatterns.get(indexPatternId);
    });
    (0, _defineProperty2.default)(this, "onChange", value => this.props.setValue('controls', value));
    (0, _defineProperty2.default)(this, "handleLabelChange", (controlIndex, label) => {
      const updatedControl = {
        ...this.props.stateParams.controls[controlIndex],
        label
      };
      this.onChange((0, _editor_utils.setControl)(this.props.stateParams.controls, controlIndex, updatedControl));
    });
    (0, _defineProperty2.default)(this, "handleIndexPatternChange", (controlIndex, indexPattern) => {
      const updatedControl = {
        ...this.props.stateParams.controls[controlIndex],
        indexPattern,
        fieldName: ''
      };
      this.onChange((0, _editor_utils.setControl)(this.props.stateParams.controls, controlIndex, updatedControl));
    });
    (0, _defineProperty2.default)(this, "handleFieldNameChange", (controlIndex, fieldName) => {
      const updatedControl = {
        ...this.props.stateParams.controls[controlIndex],
        fieldName
      };
      this.onChange((0, _editor_utils.setControl)(this.props.stateParams.controls, controlIndex, updatedControl));
    });
    (0, _defineProperty2.default)(this, "handleOptionsChange", (controlIndex, optionName, value) => {
      const control = this.props.stateParams.controls[controlIndex];
      const updatedControl = {
        ...control,
        options: {
          ...control.options,
          [optionName]: value
        }
      };
      this.onChange((0, _editor_utils.setControl)(this.props.stateParams.controls, controlIndex, updatedControl));
    });
    (0, _defineProperty2.default)(this, "handleRemoveControl", controlIndex => {
      this.onChange((0, _editor_utils.removeControl)(this.props.stateParams.controls, controlIndex));
    });
    (0, _defineProperty2.default)(this, "moveControl", (controlIndex, direction) => {
      this.onChange((0, _editor_utils.moveControl)(this.props.stateParams.controls, controlIndex, direction));
    });
    (0, _defineProperty2.default)(this, "handleAddControl", () => {
      this.onChange((0, _editor_utils.addControl)(this.props.stateParams.controls, (0, _editor_utils.newControl)(this.state.type)));
    });
    (0, _defineProperty2.default)(this, "handleParentChange", (controlIndex, parent) => {
      const updatedControl = {
        ...this.props.stateParams.controls[controlIndex],
        parent
      };
      this.onChange((0, _editor_utils.setControl)(this.props.stateParams.controls, controlIndex, updatedControl));
    });
  }
  renderControls() {
    const lineageMap = (0, _lineage.getLineageMap)(this.props.stateParams.controls);
    return this.props.stateParams.controls.map((controlParams, controlIndex) => {
      const parentCandidates = (0, _lineage.getParentCandidates)(this.props.stateParams.controls, controlParams.id, lineageMap);
      return /*#__PURE__*/_react.default.createElement(_control_editor.ControlEditor, {
        key: controlParams.id,
        controlIndex: controlIndex,
        controlParams: controlParams,
        handleLabelChange: this.handleLabelChange,
        moveControl: this.moveControl,
        handleRemoveControl: this.handleRemoveControl,
        handleIndexPatternChange: this.handleIndexPatternChange,
        handleFieldNameChange: this.handleFieldNameChange,
        getIndexPattern: this.getIndexPattern,
        handleOptionsChange: this.handleOptionsChange,
        parentCandidates: parentCandidates,
        handleParentChange: this.handleParentChange,
        deps: this.props.deps,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 9
        }
      });
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 7
      }
    }, this.renderControls(), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: "selectControlType",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-test-subj": "selectControlType",
      options: [{
        value: _editor_utils.CONTROL_TYPES.RANGE,
        text: _i18n.i18n.translate('inputControl.editor.controlsTab.select.rangeDropDownOptionLabel', {
          defaultMessage: 'Range slider'
        })
      }, {
        value: _editor_utils.CONTROL_TYPES.LIST,
        text: _i18n.i18n.translate('inputControl.editor.controlsTab.select.listDropDownOptionLabel', {
          defaultMessage: 'Options list'
        })
      }],
      value: this.state.type,
      onChange: event => this.setState({
        type: event.target.value
      }),
      "aria-label": _i18n.i18n.translate('inputControl.editor.controlsTab.select.controlTypeAriaLabel', {
        defaultMessage: 'Select control type'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: "addControl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      onClick: this.handleAddControl,
      iconType: "plusInCircle",
      "data-test-subj": "inputControlEditorAddBtn",
      "aria-label": _i18n.i18n.translate('inputControl.editor.controlsTab.select.addControlAriaLabel', {
        defaultMessage: 'Add control'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "inputControl.editor.controlsTab.addButtonLabel",
      defaultMessage: "Add",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 19
      }
    })))))));
  }
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
exports.default = ControlsTab;
module.exports = exports.default;