"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _flyout_content = require("./flyout_content");
var _shared_imports = require("../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/sections/pipelines_list/pipeline_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DETAILS_VIEW = 1;
const TREE_VIEW = 2;
const PipelineFlyout = ({
  ingestPipeline,
  onClose,
  onCreateClick,
  onEditClick,
  onCloneClick,
  onDeleteClick
}) => {
  var _treeRootStack$at, _treeData$pipelineStr;
  const {
    services: {
      api
    }
  } = (0, _shared_imports.useKibana)();
  const [pipelineName, setPipelineName] = (0, _react.useState)(ingestPipeline);
  const [treeRootStack, setTreeRootStack] = (0, _react.useState)([ingestPipeline]);
  (0, _react.useEffect)(() => {
    if (treeRootStack.length > 0) {
      setPipelineName(treeRootStack.at(-1));
    }
  }, [treeRootStack]);
  const {
    data: pipeline,
    isLoading,
    error
  } = api.useLoadPipeline(pipelineName);
  const {
    data: treeData
  } = api.useLoadPipelineTree((_treeRootStack$at = treeRootStack.at(-1)) !== null && _treeRootStack$at !== void 0 ? _treeRootStack$at : '');
  const isResponsiveFlyout = (0, _eui.useIsWithinBreakpoints)(['xs', 's', 'm']);
  const [responsiveFlyoutContent, setResponsiveFlyoutContent] = (0, _react.useState)(DETAILS_VIEW);
  const pipelineTree = treeData !== null && treeData !== void 0 && (_treeData$pipelineStr = treeData.pipelineStructureTree) !== null && _treeData$pipelineStr !== void 0 && _treeData$pipelineStr.children && treeData.pipelineStructureTree.children.length > 0 ? treeData.pipelineStructureTree : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": "pipelineDetailsFlyoutTitle",
    "data-test-subj": "pipelineDetails",
    size: "l",
    maxWidth: pipelineTree ? 1100 : 550,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    direction: "row",
    grow: true,
    responsive: false,
    borderRadius: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, pipelineTree && (!isResponsiveFlyout || responsiveFlyoutContent === TREE_VIEW) && /*#__PURE__*/_react.default.createElement(_flyout_content.TreePanel, {
    pipelineTree: pipelineTree,
    selectedPipeline: isResponsiveFlyout ? undefined : pipelineName,
    clickTreeNode: name => {
      setPipelineName(name);
      if (isResponsiveFlyout) {
        setResponsiveFlyoutContent(DETAILS_VIEW);
      }
    },
    setTreeRootStack: setTreeRootStack,
    isExtension: treeRootStack.length > 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }), (!isResponsiveFlyout || responsiveFlyoutContent === DETAILS_VIEW) && (isLoading ? /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.list.pipelineDetails.loading",
    defaultMessage: "Loading pipeline\u2026",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 15
    }
  })) : error ? /*#__PURE__*/_react.default.createElement(_flyout_content.NotFoundPanel, {
    pipelineName: pipelineName,
    onCreatePipeline: () => onCreateClick(pipelineName),
    error: error,
    displayWarning: pipelineName !== ingestPipeline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }) : pipeline && /*#__PURE__*/_react.default.createElement(_flyout_content.DetailsPanel, {
    pipeline: pipeline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 25
    }
  }))), (isResponsiveFlyout && responsiveFlyoutContent === DETAILS_VIEW || !error) && pipeline && /*#__PURE__*/_react.default.createElement(_flyout_content.FlyoutFooter, {
    pipeline: pipeline,
    onEditClick: onEditClick,
    onCloneClick: onCloneClick,
    onDeleteClick: onDeleteClick,
    renderActions: !error,
    renderViewTreeButton: isResponsiveFlyout && responsiveFlyoutContent === DETAILS_VIEW,
    onViewTreeClick: () => setResponsiveFlyoutContent(TREE_VIEW),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }));
};
exports.PipelineFlyout = PipelineFlyout;