"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Sort = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../../../shared_imports");
var _field_name_field = require("./common_fields/field_name_field");
var _target_field = require("./common_fields/target_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/sort.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const fieldsConfig = {
  /* Optional fields config */
  order: {
    type: _shared_imports.FIELD_TYPES.SELECT,
    defaultValue: 'asc',
    deserializer: v => v === 'asc' || v === 'desc' ? v : 'asc',
    serializer: v => v === 'asc' || v === '' ? undefined : v,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.sortForm.orderFieldLabel', {
      defaultMessage: 'Order'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.sortForm.orderFieldHelpText', {
      defaultMessage: 'Sort order. Arrays containing a mix of strings and numbers are sorted lexicographically.'
    })
  }
};
const Sort = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.sortForm.fieldNameHelpText', {
      defaultMessage: 'Field containing array values to sort.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.order,
    component: _shared_imports.SelectField,
    componentProps: {
      euiFieldProps: {
        options: [{
          value: 'asc',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.sortForm.orderField.ascendingOption', {
            defaultMessage: 'Ascending'
          })
        }, {
          value: 'desc',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.sortForm.orderField.descendingOption', {
            defaultMessage: 'Descending'
          })
        }]
      }
    },
    path: "fields.order",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }));
};
exports.Sort = Sort;