"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineProcessorsItemTooltip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _processor_information = require("./processor_information");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/pipeline_processors_editor_item_tooltip/pipeline_processors_editor_item_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MOUSE_PADDING_RIGHT = 20;
const MOUSE_PADDING_BOTTOM = 20;
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    tooltip: (0, _react2.css)`
      position: fixed;
      pointer-events: none;
      z-index: ${euiTheme.levels.menu};
    `
  };
};
const PipelineProcessorsItemTooltip = ({
  processor
}) => {
  const [position, setPosition] = (0, _react.useState)();
  const styles = useStyles();
  (0, _react.useEffect)(() => {
    const mouseMoveListener = event => {
      setPosition({
        x: event.pageX,
        y: event.pageY - window.scrollY
      });
    };
    document.addEventListener('mousemove', mouseMoveListener);
    return () => {
      document.removeEventListener('mousemove', mouseMoveListener);
    };
  }, []);
  if (!position) {
    return null;
  }
  return (
    /*#__PURE__*/
    /**
     * To get around issues with parent elements potentially being position: relative or
     * overflow: hidden we use a portal to render this tooltip in the document body so
     * that we can render it anywhere the cursor can go.
     */
    _react.default.createElement(_eui.EuiPortal, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 5
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: styles.tooltip,
      style: {
        left: position.x + MOUSE_PADDING_RIGHT,
        top: position.y + MOUSE_PADDING_BOTTOM
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_processor_information.ProcessorInformation, {
      processor: processor,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    })))
  );
};
exports.PipelineProcessorsItemTooltip = PipelineProcessorsItemTooltip;