"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicesConfigurationPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../../../../common/constants");
var _use_kibana = require("../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/settings/indices_configuration_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const METRIC_INDICES_WARNING_TITLE = _i18n.i18n.translate('xpack.infra.sourceConfiguration.metricIndicesDoNotExistTitle', {
  defaultMessage: 'No matching index found'
});
const METRIC_INDICES_USED_BY_RULES = _i18n.i18n.translate('xpack.infra.sourceConfiguration.metricIndicesUsedByRulesTitle', {
  defaultMessage: 'Alerting rules use this data source setting'
});
const REMOTE_CLUSTER_ERROR_TITLE = _i18n.i18n.translate('xpack.infra.sourceConfiguration.remoteClusterConnectionDoNotExistTitle', {
  defaultMessage: 'Couldn’t connect to the remote cluster'
});
const IndicesConfigurationPanel = ({
  isLoading,
  readOnly,
  metricAliasFieldProps,
  metricIndicesExist,
  remoteClustersExist,
  isMetricAliasChanged,
  numberOfInfraRules
}) => {
  const {
    services: {
      share: {
        url: {
          locators
        }
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const rulesLocator = locators.get(_public.rulesLocatorID);
  const viewAffectedRulesLink = rulesLocator === null || rulesLocator === void 0 ? void 0 : rulesLocator.useUrl({
    type: [_ruleDataUtils.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID, _ruleDataUtils.METRIC_THRESHOLD_ALERT_TYPE_ID]
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.indicesSectionTitle",
    defaultMessage: "Indices",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.sourceConfiguration.metricIndicesTitle",
      defaultMessage: "Metrics indices",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.sourceConfiguration.metricIndicesDescription",
      defaultMessage: "Index pattern for matching indices that contain metrics data",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: metricAliasFieldProps.error,
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.sourceConfiguration.metricIndicesRecommendedValue",
      defaultMessage: "The recommended value is {defaultValue}",
      values: {
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 120,
            columnNumber: 31
          }
        }, _constants.METRICS_INDEX_PATTERN)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 13
      }
    }),
    isInvalid: metricAliasFieldProps.isInvalid,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.sourceConfiguration.metricIndicesLabel",
      defaultMessage: "Metrics indices",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    "data-test-subj": "metricIndicesInput",
    fullWidth: true,
    disabled: isLoading,
    readOnly: readOnly,
    isLoading: isLoading
  }, metricAliasFieldProps, {
    isInvalid: metricAliasFieldProps.isInvalid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }))), isMetricAliasChanged && numberOfInfraRules > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "infraIndicesPanelSettingsWarningCalloutUsedByRules",
    size: "s",
    title: METRIC_INDICES_USED_BY_RULES,
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.metricIndicesUsedByRulesMessage",
    defaultMessage: "One or more alerting rules rely on this data source setting. Changing this setting will change which data is used to generate alerts.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "metricIndicesViewAffectedRulesLink",
    href: viewAffectedRulesLink,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.metricIndices.viewAffectedRulesLink",
    defaultMessage: "View affected rules",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 17
    }
  })))), remoteClustersExist && !metricIndicesExist && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: METRIC_INDICES_WARNING_TITLE,
    color: "warning",
    iconType: "warning",
    "data-test-subj": "infraIndicesPanelSettingsWarningCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.metricIndicesDoNotExist",
    defaultMessage: "We couldn\u2019t find any metrics data because the pattern entered doesn\u2019t match any index.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 15
    }
  }))), !remoteClustersExist && !metricIndicesExist && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "infraIndicesPanelSettingsDangerCallout",
    size: "s",
    title: REMOTE_CLUSTER_ERROR_TITLE,
    color: "danger",
    iconType: "error",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.sourceConfiguration.remoteClusterConnectionDoNotExist",
    defaultMessage: "Check that the remote cluster is available or that the remote connection settings are correct.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 15
    }
  })))));
};
exports.IndicesConfigurationPanel = IndicesConfigurationPanel;