"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerMetrics = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/metrics-data-access-plugin/common");
var _metrics_source = require("../../../../containers/metrics_source");
var _color_palette = require("../../../../../common/color_palette");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/metrics_explorer/components/metrics.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const placeholderText = _i18n.i18n.translate('xpack.infra.metricsExplorer.metricComboBoxPlaceholder', {
  defaultMessage: 'choose a metric to plot'
});
const comboValidationText = _i18n.i18n.translate('xpack.infra.metricsExplorer.maxItemsSelected', {
  defaultMessage: 'Maximum number of {maxMetrics} metrics reached.',
  values: {
    maxMetrics: _common.METRICS_EXPLORER_API_MAX_METRICS
  }
});
const MetricsExplorerMetrics = ({
  options,
  onChange,
  autoFocus = false
}) => {
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const colors = Object.keys(_color_palette.Color);
  const [shouldFocus, setShouldFocus] = (0, _react.useState)(autoFocus);
  const maxMetricsReached = options.metrics.length >= _common.METRICS_EXPLORER_API_MAX_METRICS;

  // the EuiCombobox forwards the ref to an input element
  const autoFocusInputElement = (0, _react.useCallback)(inputElement => {
    if (inputElement && shouldFocus) {
      inputElement.focus();
      setShouldFocus(false);
    }
  }, [shouldFocus]);
  const handleChange = (0, _react.useCallback)(selectedOptions => {
    onChange(selectedOptions.map((opt, index) => ({
      aggregation: options.aggregation,
      field: opt.value,
      color: colors[index]
    })));
  }, [onChange, options.aggregation, colors]);
  const comboOptions = (0, _react.useMemo)(() => {
    var _metricsView$fields;
    return maxMetricsReached ? [{
      label: comboValidationText,
      disabled: true
    }] : ((_metricsView$fields = metricsView === null || metricsView === void 0 ? void 0 : metricsView.fields) !== null && _metricsView$fields !== void 0 ? _metricsView$fields : []).map(field => ({
      label: field.name,
      value: field.name
    }));
  }, [maxMetricsReached, metricsView === null || metricsView === void 0 ? void 0 : metricsView.fields]);
  const selectedOptions = options.metrics.filter(m => m.aggregation !== 'count').map(metric => ({
    label: metric.field || '',
    value: metric.field || '',
    color: (0, _color_palette.colorTransformer)(metric.color || _color_palette.Color.color0)
  }));
  const handleOnKeyDown = ev => {
    if (maxMetricsReached) {
      ev.preventDefault();
    }
    return ev;
  };
  const renderFields = (0, _react.useCallback)(option => {
    const {
      label,
      disabled
    } = option;
    if (disabled) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        justifyContent: "center",
        alignItems: "center",
        "data-test-subj": "infraMetricsExplorerMaxMetricsReached",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        justifyContent: "center",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "info",
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 15
        }
      }, label))));
    }
    return label;
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "metricsExplorer-metrics",
    "aria-label": placeholderText,
    isDisabled: options.aggregation === 'count',
    placeholder: placeholderText,
    fullWidth: true,
    compressed: true,
    options: comboOptions,
    selectedOptions: selectedOptions,
    onChange: handleChange,
    onKeyDown: handleOnKeyDown,
    isClearable: true,
    inputRef: autoFocusInputElement,
    renderOption: renderFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 5
    }
  });
};
exports.MetricsExplorerMetrics = MetricsExplorerMetrics;