"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetDetailsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _asset_details = require("../../../../../components/asset_details");
var _asset_details_tabs = require("../../../../../common/asset_details_config/asset_details_tabs");
var _use_waffle_options = require("../../hooks/use_waffle_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/asset_details_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ONE_HOUR = 60 * 60 * 1000;
const AssetDetailsFlyout = ({
  entityName,
  entityId,
  entityType,
  closeFlyout,
  currentTime,
  options,
  refreshInterval,
  isAutoReloading = false
}) => {
  const {
    preferredSchema
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const dateRange = (0, _react.useMemo)(() => {
    // forces relative dates when auto-refresh is active
    return isAutoReloading ? {
      from: 'now-1h',
      to: 'now'
    } : {
      from: new Date(currentTime - ONE_HOUR).toISOString(),
      to: new Date(currentTime).toISOString()
    };
  }, [currentTime, isAutoReloading]);
  return /*#__PURE__*/_react.default.createElement(_asset_details.AssetDetails, {
    entityId: entityId,
    entityName: entityName,
    entityType: entityType,
    overrides: {
      metadata: {
        showActionsColumn: false
      },
      alertRule: {
        options
      }
    },
    tabs: (0, _asset_details_tabs.getAssetDetailsFlyoutTabs)(entityType),
    links: ['nodeDetails'],
    renderMode: {
      mode: 'flyout',
      closeFlyout
    },
    dateRange: dateRange,
    autoRefresh: {
      isPaused: !isAutoReloading,
      interval: refreshInterval
    },
    preferredSchema: preferredSchema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  });
};
exports.AssetDetailsFlyout = AssetDetailsFlyout;