"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAfterLoadedState = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAfterLoadedState = (loading, state) => {
  const ref = (0, _react.useRef)(undefined);
  const [internalState, setInternalState] = (0, _react.useState)(state);
  if (!ref.current || loading !== ref.current) {
    ref.current = loading;
  }
  (0, _react.useEffect)(() => {
    if (!loading) {
      setInternalState(state);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [ref.current]);
  return {
    afterLoadedState: internalState
  };
};
exports.useAfterLoadedState = useAfterLoadedState;