"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsTabContent = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _esQuery = require("@kbn/es-query");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../../../../../hooks/use_kibana");
var _build = require("../../../../../../utils/filters/build");
var _use_hosts_view = require("../../../hooks/use_hosts_view");
var _use_logs_search_url_state = require("../../../hooks/use_logs_search_url_state");
var _use_unified_search = require("../../../hooks/use_unified_search");
var _logs_search_bar = require("./logs_search_bar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/hosts/components/tabs/logs/logs_tab_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogsTabContent = () => {
  const {
    services: {
      logsShared: {
        LogsOverview
      },
      uiSettings
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    parsedDateRange
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const timeRange = (0, _react.useMemo)(() => ({
    start: parsedDateRange.from,
    end: parsedDateRange.to
  }), [parsedDateRange.from, parsedDateRange.to]);
  const {
    hostNodes,
    loading,
    error
  } = (0, _use_hosts_view.useHostsViewContext)();
  const [filterQuery] = (0, _use_logs_search_url_state.useLogsSearchUrlState)();
  const logFilters = (0, _react.useMemo)(() => [(0, _esQuery.buildEsQuery)(undefined, filterQuery, (0, _build.buildCombinedAssetFilter)({
    field: 'host.name',
    values: hostNodes.map(p => p.name)
  }), (0, _public.getEsQueryConfig)(uiSettings))], [filterQuery, hostNodes, uiSettings]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(LogsOverview.LoadingContent, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 12
      }
    });
  } else if (error != null) {
    return /*#__PURE__*/_react.default.createElement(LogsOverview.ErrorContent, {
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 12
      }
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "m",
      "data-test-subj": "hostsView-logs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_logs_search_bar.LogsSearchBar, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(LogsOverview, {
      documentFilters: logFilters,
      timeRange: timeRange,
      height: "60vh",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 11
      }
    })));
  }
};
exports.LogsTabContent = LogsTabContent;