"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsSearchBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_logs_search_url_state = require("../../../hooks/use_logs_search_url_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/hosts/components/tabs/logs/logs_search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const debounceIntervalInMs = 1000;
const LogsSearchBar = () => {
  const [filterQuery, setFilterQuery] = (0, _use_logs_search_url_state.useLogsSearchUrlState)();
  const [searchText, setSearchText] = (0, _react.useState)(filterQuery.query);
  const onQueryChange = (0, _react.useCallback)(e => {
    setSearchText(e.target.value);
  }, []);
  (0, _useDebounce.default)(() => setFilterQuery({
    ...filterQuery,
    query: searchText
  }), debounceIntervalInMs, [searchText]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "hostsView-logs-text-field-search",
    fullWidth: true,
    isClearable: true,
    placeholder: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.logs.textFieldPlaceholder', {
      defaultMessage: 'Search for log entries...'
    }),
    onChange: onQueryChange,
    value: searchText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  });
};
exports.LogsSearchBar = LogsSearchBar;