"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntryTitle = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _customIcons = require("@kbn/custom-icons");
var _public = require("@kbn/metrics-data-access-plugin/public");
var _use_unified_search = require("../../hooks/use_unified_search");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/hosts/components/table/entry_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EntryTitle = ({
  onClick,
  title
}) => {
  var _searchCriteria$prefe;
  const {
    name,
    cloudProvider
  } = title;
  const {
    parsedDateRange,
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    getAssetDetailUrl
  } = (0, _public.useAssetDetailsRedirect)();
  const link = getAssetDetailUrl({
    entityId: name,
    entityType: 'host',
    search: {
      from: parsedDateRange !== null && parsedDateRange !== void 0 && parsedDateRange.from ? new Date(parsedDateRange === null || parsedDateRange === void 0 ? void 0 : parsedDateRange.from).getTime() : undefined,
      to: parsedDateRange !== null && parsedDateRange !== void 0 && parsedDateRange.to ? new Date(parsedDateRange.to).getTime() : undefined,
      name
    },
    preferredSchema: (_searchCriteria$prefe = searchCriteria === null || searchCriteria === void 0 ? void 0 : searchCriteria.preferredSchema) !== null && _searchCriteria$prefe !== void 0 ? _searchCriteria$prefe : 'semconv'
  });
  const providerName = cloudProvider !== null && cloudProvider !== void 0 ? cloudProvider : 'Unknown';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    anchorClassName: "eui-displayBlock",
    content: _i18n.i18n.translate('xpack.infra.hostsViewPage.table.nameTooltip', {
      defaultMessage: '{providerName}: {name}',
      values: {
        providerName,
        name
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "hostsViewTableEntryTitleLink",
    "aria-label": _i18n.i18n.translate('xpack.infra.hostsViewPage.table.openHostDetailsLink.ariaLabel', {
      defaultMessage: 'Open host details {hostName}',
      values: {
        hostName: name
      }
    })
  }, link, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "eui-textTruncate",
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_customIcons.CloudProviderIcon, {
    cloudProvider: cloudProvider,
    size: "m",
    title: providerName,
    role: "presentation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }, name)))));
};
exports.EntryTitle = EntryTitle;