"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogEntryExamples = void 0;
var _react = require("react");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_tracked_promise = require("../../../hooks/use_tracked_promise");
var _get_log_entry_examples = require("./service_calls/get_log_entry_examples");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogEntryExamples = ({
  dataset,
  endTime,
  exampleCount,
  logViewReference,
  idFormat,
  startTime,
  categoryId
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [logEntryExamples, setLogEntryExamples] = (0, _react.useState)([]);
  const [getLogEntryExamplesRequest, getLogEntryExamples] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'creation',
    createPromise: async () => {
      if (!idFormat) {
        throw new Error('idFormat is undefined');
      }
      return await (0, _get_log_entry_examples.callGetLogEntryExamplesAPI)({
        logViewReference,
        idFormat,
        startTime,
        endTime,
        dataset,
        exampleCount,
        categoryId
      }, services.http.fetch);
    },
    onResolve: ({
      data: {
        examples
      }
    }) => {
      setLogEntryExamples(examples);
    }
  }, [dataset, endTime, exampleCount, logViewReference, startTime, idFormat]);
  const isLoadingLogEntryExamples = (0, _react.useMemo)(() => getLogEntryExamplesRequest.state === 'pending', [getLogEntryExamplesRequest.state]);
  const hasFailedLoadingLogEntryExamples = (0, _react.useMemo)(() => getLogEntryExamplesRequest.state === 'rejected', [getLogEntryExamplesRequest.state]);
  return {
    getLogEntryExamples,
    hasFailedLoadingLogEntryExamples,
    isLoadingLogEntryExamples,
    logEntryExamples
  };
};
exports.useLogEntryExamples = useLogEntryExamples;