"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _metrics_source = require("../../../containers/metrics_source");
var _flyout_home = require("./flyout_home");
var _job_setup_screen = require("./job_setup_screen");
var _infra_ml_capabilities = require("../../../containers/ml/infra_ml_capabilities");
var _module = require("../../../containers/ml/modules/metrics_hosts/module");
var _module2 = require("../../../containers/ml/modules/metrics_k8s/module");
var _use_kibana_space = require("../../../hooks/use_kibana_space");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/ml/anomaly_detection/anomaly_detection_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnomalyDetectionFlyout = ({
  hideJobType = false,
  hideSelectGroup = false
}) => {
  var _metricsView$indices, _metricsView$indices2;
  const {
    hasInfraMLSetupCapabilities
  } = (0, _infra_ml_capabilities.useInfraMLCapabilities)();
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const [screenName, setScreenName] = (0, _react.useState)('home');
  const [screenParams, setScreenParams] = (0, _react.useState)(null);
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const {
    space
  } = (0, _use_kibana_space.useActiveKibanaSpace)();
  const openFlyout = (0, _react.useCallback)(() => {
    setScreenName('home');
    setShowFlyout(true);
  }, []);
  const openJobSetup = (0, _react.useCallback)(jobType => {
    setScreenName('setup');
    setScreenParams({
      jobType
    });
  }, [setScreenName]);
  const closeFlyout = (0, _react.useCallback)(() => {
    setShowFlyout(false);
  }, []);
  if (!(metricsView !== null && metricsView !== void 0 && metricsView.indices) || !space) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    onClick: openFlyout,
    "data-test-subj": "openAnomalyFlyoutButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.ml.anomalyDetectionButton",
    defaultMessage: "Anomaly detection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  })), showFlyout && /*#__PURE__*/_react.default.createElement(_module.MetricHostsModuleProvider, {
    indexPattern: (_metricsView$indices = metricsView === null || metricsView === void 0 ? void 0 : metricsView.indices) !== null && _metricsView$indices !== void 0 ? _metricsView$indices : '',
    sourceId: "default",
    spaceId: space.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_module2.MetricK8sModuleProvider, {
    indexPattern: (_metricsView$indices2 = metricsView === null || metricsView === void 0 ? void 0 : metricsView.indices) !== null && _metricsView$indices2 !== void 0 ? _metricsView$indices2 : '',
    sourceId: "default",
    spaceId: space.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    "data-test-subj": "loadMLFlyout",
    "aria-label": _i18n.i18n.translate('xpack.infra.ml.anomalyDetectionFlyoutAriaLabel', {
      defaultMessage: 'Anomaly detection flyout'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 13
    }
  }, screenName === 'home' && /*#__PURE__*/_react.default.createElement(_flyout_home.FlyoutHome, {
    hasSetupCapabilities: hasInfraMLSetupCapabilities,
    goToSetup: openJobSetup,
    closeFlyout: closeFlyout,
    hideJobType: hideJobType,
    hideSelectGroup: hideSelectGroup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 17
    }
  }), screenName === 'setup' && /*#__PURE__*/_react.default.createElement(_job_setup_screen.JobSetupScreen, {
    goHome: openFlyout,
    closeFlyout: closeFlyout,
    jobType: screenParams.jobType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 17
    }
  })))));
};
exports.AnomalyDetectionFlyout = AnomalyDetectionFlyout;